/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.extensions.Membrane;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.monitoring.Monitor;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.monitoring.MonitorImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @org.objectweb.fractal.fraclet.annotations.Interface(name = "process", signature = Process.class))
@Membrane(controller = "composite")
public class ProcessImpl extends ScopeImpl implements Process {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ProcessImpl.class.getName());

	private ProcessKey key;

	private ExternalContext externalContext;

	private Monitor monitor = new MonitorImpl();

	private State state = State.PROCESS_INACTIVE;

	public ProcessImpl() throws CoreException {
		super();
	}

	public void run() throws CoreException {
		this.log.finest("run process");
		if((this.state == State.PROCESS_INACTIVE) || (this.state == State.PROCESS_ENDED)){
			this.getMonitor().reset();
			this.getMonitor().setStartTime(Calendar.getInstance().getTime());
		}
		state = State.PROCESS_ACTIVE;
		try {

			this.createParentExecution();

			this.log.finest("start parent execution");
			if (!FractalHelper.getFractalHelper().isStarted(
					this.parentExecution)) {
				FractalHelper.getFractalHelper().startComponent(
						this.parentExecution);
			}
			this.log.finest("parent execution started");

			this.log.finest("run the execution");
			final Execution exec = (Execution) this.parentExecution
			.getFcInterface("service");
			exec.run();

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		this.log.finest("end of process");
	}

	public Execution createParentExecution() throws CoreException {
		Execution res = null;
		try {
			if (this.parentExecution == null) {
				this.log.finest("create parent execution");
				this.parentExecution = FractalHelper
				.getFractalHelper()
				.createNewComponent(ExecutionImpl.class.getName(), null);

				res = (Execution) this.parentExecution
				.getFcInterface("/content");
				if (!this.log.getName().equals(ProcessImpl.class.getName())) {
					res.setLog(this.log);
				}

				FractalHelper.getFractalHelper().addComponent(
						this.parentExecution, this.getComponent(), null);
				FractalHelper.getFractalHelper().changeName(
						this.parentExecution, "mainExec");

				if(this.initialNode == null) {
					throw new CoreException("Initial node not setted");
				}
				this.linkInitialNodeAndExecution();
			}

			res = (Execution) this.parentExecution.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}

		return res;
	}

	public Map<String, Execution> getConcernedExecutions(final InternalMessage<?> message)
	throws CoreException {
		Map<String, Execution> res = new HashMap<String,Execution>();
		if (this.getParentExecution() != null) {
			res.putAll(getConcernedExecutions(message, this.getParentExecution()));
			for(Scope scope: this.getAllScopes()) {
				res.putAll(getConcernedExecutions(message, scope.getExecution()));
			}
		} else if (this.getParentExecution() == null) {
			final Execution main = this.createParentExecution();
			final Component exec = FractalHelper.getFractalHelper()
			.getComponentByInterface(this.getComponent(),
					(Interface) main, "service");
			FractalHelper.getFractalHelper().startComponent(exec);
			try {
				if(!res.containsKey(this.getParentExecution().getName())) {
					res.put(this.getParentExecution().getName(), this.getParentExecution());
				}
			} catch (CoreException e) {
				// do nothing
			}
		}

		return res;
	}

	private Map<String, Execution> getConcernedExecutions(
			InternalMessage<?> message, Execution parentExecution) {
		Map<String, Execution> res = new HashMap<String, Execution>();
		if(parentExecution != null) {
			for(Execution childExecution: parentExecution.getChildExecutions()) {
				res.putAll(getConcernedExecutions(message, childExecution));
			}
		}
		
		if((parentExecution != null)&&(parentExecution.getState().equals(Execution.State.SUSPENDED))&&(parentExecution.getCurrentTarget() != null)&&(parentExecution.getCurrentTarget() instanceof Node)) {
			Node node = (Node)parentExecution.getCurrentTarget();
			if(node.getBehaviour() instanceof ReceiverBehaviour) {
				try {
					if(!res.containsKey(parentExecution.getName())) {
						res.put(parentExecution.getName(), parentExecution);
					}
				} catch (CoreException e) {
					// do nothing
				}
			}
		}
		return res;
	}

	public Engine getEngine() throws CoreException {
		Engine res = null;
		try {
			final Component engineComp = FractalHelper.getFractalHelper().getParent(
					this.getComponent());
			res = (Engine) engineComp.getFcInterface("service");
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	@Override
	public com.ebmwebsourcing.easyviper.core.api.engine.Process getProcess()
	throws CoreException {
		return this;
	}

	public ProcessKey getProcessKey() {
		return this.key;
	}

	public void setProcessKey(final ProcessKey key) {
		this.key = key;
	}

	public ExternalContext getExternalContext() {
		return this.externalContext;
	}

	public void setExternalContext(final ExternalContext context) {
		this.externalContext = context;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	public Monitor getMonitor() {
		return this.monitor;
	}


	@Override
	public void end(boolean clean) throws CoreException {
		super.end(clean);
		this.state = Process.State.PROCESS_ENDED;
		this.log.finest("PROCESS ENDED : " + this.getName());
		this.getMonitor().setEndTime(Calendar.getInstance().getTime());

		if(externalContext != null && externalContext.getTerminationHandler() != null) {
			externalContext.getTerminationHandler().end(this);
		}
	}

	public State getState() {
		return this.state;
	}

	public void setState(State state) {
		this.state = state;
	}

	@Override
	public String toString() {
		String res = super.toString();
		try {
			if(this.getName() != null) {
				res = this.getName();
			}
		} catch (CoreException e) {
			// do nothing
		}
		return res;
	}
	
	
}
