/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.EchoBehaviour;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = EchoBehaviour.class))
public class EchoBehaviourImpl extends AbstractBehaviourImpl implements EchoBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(EchoBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;

	private String message;

	public EchoBehaviourImpl() {
	}

	public Map<String, Object> getInitializationContext()
			throws CoreException {
		final Map<String, Object> context = new HashMap<String, Object>();
		context.put("message", this.message);
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
			throws CoreException {
		this.message = (String) context.get("message");
	}

	@Override
	public void executeActivity() throws CoreException {
		this.log.finest("start echo behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;
		this.log.finest("execute echo behaviour: " + this.message);
		System.out.println(this.message);
	}

	@Override
	public String toString() {
		return "EchoActivity";
	}

	public String getMessage() {
		return this.message;
	}

	public void setMessage(final String message) {
		this.message = message;
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

}