/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ExitBehaviour;

/**
 * 
 * @author "Mathieu CARROLLE - eBM WebSourcing"
 *
 */
@org.objectweb.fractal.fraclet.annotations.Component
public class ExitBehaviourImpl extends AbstractBehaviourImpl implements ExitBehaviour {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ExitBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;
	
	@Override
	public void executeActivity() throws CoreException {
		this.log.finest("start exit behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;
		try{
			this.getNode().getExecution().setState(Execution.State.CANCELLED);
			
			// cancelled all parent execution
			Execution parent = this.getNode().getExecution().getParentExecution();
			while(parent != null) {
				parent.setState(Execution.State.CANCELLED);
				parent = this.getNode().getExecution().getParentExecution();
			}
			
		}catch (NullPointerException e) {
			this.log.severe("Cause of NPE : "+e.getCause());
		}finally{
			this.state = State.ACTIVITY_ENDED;
		}
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	public Map<String, Object> getInitializationContext()
			throws CoreException {
		// TODO Auto-generated method stub
		return null;
	}

	public void setInitializationContext(Map<String, Object> context)
			throws CoreException {
		//do nothing
	}

	@Override
	public String toString() {
		return "ExitActivity";
	}

	@Override
	public void setLog(Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}
}
