/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ForkBehaviour;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = ForkBehaviour.class))
public class ForkBehaviourImpl extends AbstractBehaviourImpl implements ForkBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ForkBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;

	public Map<String, Object> getInitializationContext()
			throws CoreException {
		return null;
	}

	public void setInitializationContext(final Map<String, Object> context)
			throws CoreException {
		// do nothing
	}

	@Override
	public void executeActivity() throws CoreException {
		if (this.state == State.ACTIVITY_INACTIVE) {
			this.log.finest("start fork behaviour on node: " + this.node.getName());
			this.state = State.ACTIVITY_STARTED;

			// select all child nodes
			final List<Node> childs = this.node.getChildNodes();
			

			
			this.getNode().getNextSelectedExecutableElements().addAll(childs);

		} else if (this.state == State.ACTIVITY_STARTED) {
			if (this.getNode().getExecution().getChildExecutions().size() == 0) {
				this.log.finest("fork activity started => number of childs: "
						+ this.getNode().getExecution().getChildExecutions()
								.size());
				this.log
						.finest("end fork behaviour on node: "
								+ this.node.getName());
				this.state = State.ACTIVITY_ENDED;
				
				// end all child activity
				final List<Node> childs = this.node.getChildNodes();
				for(Node child: childs) {
					child.getBehaviour().setState(Behaviour.State.ACTIVITY_ENDED);
				}
				
				this.getNode().getNextSelectedExecutableElements().clear();
			} else {
				if (this.getNode().getExecution().getState() == Execution.State.ACTIVE) {
					// suspend the parent execution
					this.log.finest("fork activity: parent execution suspended");
					this.getNode().getExecution().setState(
							Execution.State.SUSPENDED);
				}
				this.getNode().getNextSelectedExecutableElements().clear();
				this.getNode().getNextSelectedExecutableElements().add(
						this.getNode());
			}
		}
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public String toString() {
		return "Fork";
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}
}