/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = IfBehaviour.class))
public class IfBehaviourImpl extends AbstractBehaviourImpl implements IfBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(IfBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;

	private List<ConditionalExpression> conditions;

	public Map<String, Object> getInitializationContext()
	throws CoreException {
		final Map<String, Object> context = new HashMap<String, Object>();
		context.put("conditions", this.conditions);
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
	throws CoreException {
		this.conditions = (List<ConditionalExpression>) context
		.get("conditions");
	}

	@Override
	public void executeActivity() throws CoreException {
		if (this.state == State.ACTIVITY_INACTIVE) {
			this.log.finest("start if behaviour on node: " + this.node.getName());
			this.state = State.ACTIVITY_STARTED;

			if ((this.conditions != null) && (this.conditions.size() > 0)) {
				final Iterator<ConditionalExpression> itExpressions = this.conditions
				.iterator();
				final Iterator<Node> itNodes = this.node.getChildNodes().iterator();

				ConditionalExpression expression = null;
				Node selectedChild = null;
				boolean find = false;
				while ((itExpressions.hasNext()) && (!find)) {
					expression = itExpressions.next();
					selectedChild = itNodes.next();
					Boolean cond = (Boolean) expression.evaluate(this.getNode().getExecution()
							.getParentScope());
					if (cond != null && cond == true) {
						this.getNode().getNextSelectedExecutableElements().add(
								selectedChild);
						find = true;
					} 
				}

				if ((!find) && (itNodes.hasNext())) {
					selectedChild = itNodes.next();
					this.getNode().getNextSelectedExecutableElements().add(
							selectedChild);
				}

			} else {
				throw new CoreException("Invalid if pattern");
			}

		} else if (this.state == State.ACTIVITY_STARTED) {
			this.log.finest("end if behaviour on node: " + this.node.getName());
			this.state = State.ACTIVITY_ENDED;
			this.getNode().getNextSelectedExecutableElements().clear();
		}
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public String toString() {
		return "If behaviour";
	}

	public List<ConditionalExpression> getConditions() {
		return this.conditions;
	}

	public void setConditions(final List<ConditionalExpression> expression) {
		this.conditions = expression;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

}
