/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ScopeBehaviour;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @org.objectweb.fractal.fraclet.annotations.Interface(name = "service", signature = ScopeBehaviour.class))
public class ScopeBehaviourImpl extends AbstractBehaviourImpl implements ScopeBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ScopeBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;


	public ScopeBehaviourImpl() {
	}

	public Map<String, Object> getInitializationContext()
	throws CoreException {
		final Map<String, Object> context = new HashMap<String, Object>();
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
	throws CoreException {
	}

	@Override
	public void executeActivity() throws CoreException {
		if (this.state == State.ACTIVITY_INACTIVE) {
			this.log.finest("start scope behaviour on node: " + this.node.getName());
			this.state = State.ACTIVITY_STARTED;
		}
		
		try {
			Scope scope = (Scope) this.getNode().getComponent().getFcInterface("scope");
			Component execComp = FractalHelper.getFractalHelper().getFirstComponentByName(scope.getComponent(), "exec_in_" + scope.getName());
			Execution exec = null;
			if(execComp == null) {
				exec = scope.createExecution("exec_in_" + scope.getName());
				execComp = FractalHelper.getFractalHelper().getComponentByInterface(this.getNode().getComponent(), (Interface) exec, "service"); 
			} else  {
				exec = (Execution) execComp.getFcInterface("service");
				exec.setState(Execution.State.ACTIVE);
			}
				
			// start the execution
			if (!FractalHelper.getFractalHelper().isStarted(execComp
			)) {
				FractalHelper.getFractalHelper().startComponent(
						execComp);
			}
			scope.setParentExecution(execComp);

			if(scope.getInitialNode() != null) {
				scope.linkInitialNodeAndExecution();

				exec.setStepByStep(this.getNode().getExecution().isStepByStep());

				this.log.finest("run the execution in scope " + scope.getName());
				exec.run();
				
				// delete execution
				this.log.finest("this.getNode().getName() = " + this.getNode().getName());
				this.log.finest("this.getNode().getParentNode() = " + this.getNode().getParentNode());
				this.log.finest("scope.getParentNode() = " + scope.getParentNode());
				if(scope.getParentScope()  != null) {
					scope.getParentScope().unlinkedNodeAndExecution(scope, exec);
				}
				
				
				//FractalHelper.getFractalHelper().deleteComponent(exec.getComponent());
				
				// scope.getInitialNode().getBehaviour().setState(Behaviour.State.ACTIVITY_ENDED);
				
			} else {
				this.log.finest("empty scope => inital node = null");
			}
			
			
			this.state = State.ACTIVITY_ENDED;
			
			scope.end(false);
			
			this.log.finest("end scope behaviour on node: " + this.node.getName());
			
		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public String toString() {
		return "Scope";
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}
}