/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.monitoring;

import java.util.Date;

import com.ebmwebsourcing.easyviper.core.api.engine.monitoring.Monitor;

public class MonitorImpl implements Monitor {

	private Date start;
	
	private Date end;
	
	public Date getEndTime() {
		return this.end;
	}

	public Long getProcessTime() {
		Long res = null;
		if(this.start != null && this.end != null) {
			res = this.end.getTime() - this.start.getTime();
		}
		return res;
	}

	public Date getStartTime() {
		return this.start;
	}

	public void setEndTime(Date date) {
		this.end = date;
	}

	public void setStartTime(Date date) {
		this.start = date;
	}

	public void reset() {
		this.start = null;
		this.end = null;
	}

}
