/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.pattern;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.QName;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.ForkBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.IfBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.LoopBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.ScopeBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.SequenceBehaviourImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class CreationPatternFactory {

	private static CreationPatternFactory instance;

	private CreationPatternFactory() {

	}

	public static CreationPatternFactory getInstance() {
		if (CreationPatternFactory.instance == null) {
			CreationPatternFactory.instance = new CreationPatternFactory();
		}
		return CreationPatternFactory.instance;
	}

	public Node createSequencePattern(final String name, final List<Node> childNodes,
			final Scope scope) throws CoreException {

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}

		final Node parentNode = scope.createNode(name, new SequenceBehaviourImpl());

		if (childNodes != null) {
			// link nodes between them
			final Iterator<Node> it = childNodes.iterator();
			Node source = null;
			Node target = null;
			Node lastNode = null;
			Component sourceComp = null;
			Component targetComp = null;
			Component lastComp = null;
			Transition transition = null;
			String transitionName = "t";
			while (it.hasNext()) {
				source = it.next();
				sourceComp = FractalHelper.getFractalHelper()
				.getComponentByInterface(scope.getComponent(),
						(org.objectweb.fractal.api.Interface) source,
						"service");

				if (lastNode != null) {
					if ((FractalHelper.getFractalHelper().getName(lastComp) != null)
							&& (FractalHelper.getFractalHelper().getName(
									sourceComp) != null)) {
						transitionName = FractalHelper.getFractalHelper()
						.getName(lastComp)
						+ "2"
						+ FractalHelper.getFractalHelper().getName(
								sourceComp);
					}
					transition = scope.createTransition(transitionName, null);
					scope.linked(lastNode, transition, source);
				}

				if (it.hasNext()) {
					target = it.next();
					targetComp = FractalHelper
					.getFractalHelper()
					.getComponentByInterface(
							scope.getComponent(),
							(org.objectweb.fractal.api.Interface) target,
							"service");

					if ((FractalHelper.getFractalHelper().getName(sourceComp) != null)
							&& (FractalHelper.getFractalHelper().getName(
									targetComp) != null)) {
						transitionName = FractalHelper.getFractalHelper()
						.getName(sourceComp)
						+ "2"
						+ FractalHelper.getFractalHelper().getName(
								targetComp);
					}
					transition = scope.createTransition(transitionName, null);
					scope.linked(source, transition, target);

					lastNode = target;
					lastComp = targetComp;
				} else {
					lastNode = null;
					lastComp = null;
				}
			}

			// link all children to parent
			if (childNodes != null) {
				for (final Node children : childNodes) {
					scope.linked(parentNode, children);
				}
			}
		}

		return parentNode;
	}


	public Node createScopePattern(final String name,
			final Scope scope) throws CoreException {
		Node underscope = null; 
		try {
			if (scope == null) {
				throw new CoreException("scope cannot be null");
			}

			final Component underscopeComp = FractalHelper.getFractalHelper()
			.createNewComponent(ScopeImpl.class.getName(), null);
			
			// add scope in process
			FractalHelper.getFractalHelper().addComponent(underscopeComp,
					scope.getComponent(), null);

			underscope = (Scope) underscopeComp.getFcInterface("/content");
			(underscope).init(underscopeComp);
			underscope.setName(name);
			if (!scope.getLogger().getName().equals(ScopeImpl.class.getName())) {
				underscope.setLog(scope.getLogger());
			}

			// Start the scope
			FractalHelper.getFractalHelper().startComponent(underscopeComp);
			underscope = (Node) underscopeComp.getFcInterface("service");

			// create behaviour
			final Component fractalActivity = FractalHelper.getFractalHelper()
			.createNewComponent(ScopeBehaviourImpl.class.getName(),
					null);
			FractalHelper.getFractalHelper().changeName(
					fractalActivity,
					ScopeBehaviourImpl.class.getSimpleName()
					+ "4"
					+ FractalHelper.getFractalHelper().getName(
							underscopeComp));
			FractalHelper.getFractalHelper().addComponent(fractalActivity,
					scope.getComponent(), null);
			Behaviour behaviour = (Behaviour) fractalActivity
			.getFcInterface("/content");
			((Behaviour) behaviour).init(fractalActivity);
			if (!scope.getLogger().getName().equals(ScopeImpl.class.getName())) {
				behaviour.setLog(scope.getLogger());
			}
			behaviour = (Behaviour) fractalActivity.getFcInterface("service");

			scope.linkedNodeAndActivity(underscope, behaviour);
			underscope.setActivity(behaviour);
			
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return underscope;
	}

	public Node createIfPattern(final String name,
			final List<ConditionalExpression> expressions, final List<Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}
		if ((expressions == null)
				|| (expressions.size() == 0)
				|| ((childNodes.size() == expressions.size()) && (childNodes
						.size() == expressions.size() + 1))) {
			throw new CoreException("Invalid if pattern");
		}

		final IfBehaviour ifBehaviour = new IfBehaviourImpl();
		ifBehaviour.setConditions(expressions);
		parentNode = scope.createNode(name, ifBehaviour);

		// link all children to parent
		if (childNodes != null) {
			for (final Node children : childNodes) {
				scope.linked(parentNode, children);
			}
		}

		return parentNode;
	}

	public Node createSeveralReceiversPattern(final String name,
			final List<ReceiverBehaviour> receivers, final List<Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}
		if ((receivers == null) || (receivers.size() == 0)
				|| ((childNodes.size() != receivers.size()))) {
			throw new CoreException("Invalid several receivers pattern");
		}

		// create the list of variable
		final List<QName> variableNames = new ArrayList<QName>();
		for (final ReceiverBehaviour receiver : receivers) {
			variableNames.addAll(receiver.getVariableNames());
		}

		final ReceiverBehaviour severalReceiversBehaviour = new ReceiverBehaviourImpl();
		severalReceiversBehaviour.getVariableNames().addAll(variableNames);
		
		// set message matcher
		MessageMatcher matcher = receivers.get(0).getMessageMatcher();
		for(final ReceiverBehaviour receiver : receivers) {
			if(matcher != receiver.getMessageMatcher()) {
				throw new CoreException("Sorry but all receivers must have the same message matcher");
			}
		}
		severalReceiversBehaviour.setMessageMatcher(matcher);

		// set correlation matcher
		List<CorrelationMatcher> correlationsMatcher = null;
		for(final ReceiverBehaviour receiver : receivers) {
			if(receiver.getCorrelationsMatchers() != null) {
				if(correlationsMatcher == null) {
					correlationsMatcher = new ArrayList<CorrelationMatcher>();
				}
				correlationsMatcher.addAll(receiver.getCorrelationsMatchers());
			}
		}
		severalReceiversBehaviour.setCorrelationsMatchers(correlationsMatcher);
		
		parentNode = scope.createNode(name, severalReceiversBehaviour);

		// link all children to parent
		if (childNodes != null) {
			for (final Node children : childNodes) {
				scope.linked(parentNode, children);
			}
		}

		return parentNode;
	}

	public Node createLoopPattern(final String name, final ConditionalExpression condition, final boolean applyConditionAtBegin,
			final List<Node> childNodes, final Scope scope) throws CoreException {

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}

		if (condition == null) {
			throw new CoreException("condition cannot be null");
		}

		final LoopBehaviour loopBehaviour = new LoopBehaviourImpl();
		loopBehaviour.setCondition(condition);
		loopBehaviour.setApplyConditionAtBegin(applyConditionAtBegin);
		final Node parentNode = scope.createNode(name, loopBehaviour);

		if (childNodes != null) {
			// link nodes between them
			final Iterator<Node> it = childNodes.iterator();
			Node source = null;
			Node target = null;
			Node lastNode = null;
			Component sourceComp = null;
			Component targetComp = null;
			Component lastComp = null;
			Transition transition = null;
			String transitionName = "t";
			while (it.hasNext()) {
				source = it.next();
				sourceComp = FractalHelper.getFractalHelper()
				.getComponentByInterface(scope.getComponent(),
						(org.objectweb.fractal.api.Interface) source,
						"service");

				if (lastNode != null) {
					if ((FractalHelper.getFractalHelper().getName(lastComp) != null)
							&& (FractalHelper.getFractalHelper().getName(
									sourceComp) != null)) {
						transitionName = FractalHelper.getFractalHelper()
						.getName(lastComp)
						+ "2"
						+ FractalHelper.getFractalHelper().getName(
								sourceComp);
					}
					transition = scope.createTransition(transitionName, null);
					scope.linked(lastNode, transition, source);
				}

				if (it.hasNext()) {
					target = it.next();
					targetComp = FractalHelper
					.getFractalHelper()
					.getComponentByInterface(
							scope.getComponent(),
							(org.objectweb.fractal.api.Interface) target,
							"service");

					if ((FractalHelper.getFractalHelper().getName(sourceComp) != null)
							&& (FractalHelper.getFractalHelper().getName(
									targetComp) != null)) {
						transitionName = FractalHelper.getFractalHelper()
						.getName(sourceComp)
						+ "2"
						+ FractalHelper.getFractalHelper().getName(
								targetComp);
					}
					transition = scope.createTransition(transitionName, null);
					scope.linked(source, transition, target);

					lastNode = target;
					lastComp = targetComp;
				} else {
					lastNode = null;
					lastComp = null;
				}
			}

			// link all children to parent
			if (childNodes != null) {
				for (final Node children : childNodes) {
					scope.linked(parentNode, children);
				}
			}
		}

		return parentNode;
	}

	public Node createForkPattern(final String name, final List<Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}

		parentNode = scope.createNode(name, new ForkBehaviourImpl());

		// link all children to parent
		if (childNodes != null) {
			for (final Node children : childNodes) {
				scope.linked(parentNode, children);
			}
		}
		return parentNode;
	}
}
