/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.model;

import static org.objectweb.fractal.fraclet.types.Step.CREATE;
import static org.objectweb.fractal.fraclet.types.Step.DESTROY;
import static org.objectweb.fractal.fraclet.types.Step.START;
import static org.objectweb.fractal.fraclet.types.Step.STOP;

import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Membrane;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.Compiler;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component
@Membrane(controller = "composite")
public class ModelImpl implements Model {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ModelImpl.class.getName());

	/**
	 * The Fractal component
	 */
	@Controller
	private Component component;

	private Component compilerComponent;

	private Component registryComponent;

	/**
	 * Create the scope behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = CREATE)
	public void create() throws CoreException {
		this.log.fine("Fractal model created: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	public void init(final Component fractalNode) throws CoreException {
		this.component = fractalNode;
		this.log.fine("Fractal model initiated: "
				+ FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Start the NodeImpl behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = START)
	public void start() throws CoreException {
		this.log.fine("Fractal model started: " + this.getName());
	}

	/**
	 * Stop the NodeImpl behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = STOP)
	public void stop() throws CoreException {
		this.log.finest("sender " + this.getName() + " is stopping... ");

		this.log.finest("sender stopped: " + this.getName());
	}

	/**
	 * Destroy the NodeImpl behaviour
	 * 
	 * @throws CoreException
	 */
	@Lifecycle(step = DESTROY)
	public void destroy() throws CoreException {
		this.log.fine("Fractal model destroyed: " + this.getName());

	}

	public String getName() throws CoreException {
		return FractalHelper.getFractalHelper().getName(this.component);
	}

	public void setName(final String name) throws CoreException {
		if (name != null) {
			FractalHelper.getFractalHelper().changeName(this.component, name);
		}
	}

	public Component getComponent() {
		return this.component;
	}

	public Core getCore() throws CoreException {
		Core res = null;
		try {
			final Component coreComp = FractalHelper.getFractalHelper().getParent(
					this.getComponent());
			res = (Core) coreComp.getFcInterface("service");
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public Compiler createCompiler(final String name,
			final Class<? extends AbstractCompiler> compilerClass)
			throws CoreException {
		if (this.compilerComponent != null) {
			throw new CoreException("Error: Registry already exist!!!");
		}

		Compiler compiler = null;
		this.compilerComponent = FractalHelper.getFractalHelper()
				.createNewComponent(compilerClass.getName(), null);
		FractalHelper.getFractalHelper().addComponent(this.compilerComponent,
				this.component, null);

		try {
			compiler = (Compiler) this.compilerComponent
					.getFcInterface("/content");
			(compiler).init(this.compilerComponent);
			if (!this.log.getName().equals(ModelImpl.class.getName())) {
				compiler.setLog(this.log);
			}

			FractalHelper.getFractalHelper().startComponent(
					this.compilerComponent);
			FractalHelper.getFractalHelper().changeName(this.compilerComponent,
					name);

			compiler = (Compiler) this.compilerComponent
					.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		this.log.finest("compiler created and started");

		return compiler;
	}

	public Compiler getCompiler() throws CoreException {
		Compiler res = null;
		try {
			if (this.compilerComponent != null) {
				final Object obj = this.compilerComponent.getFcInterface("service");
				res = (Compiler) this.compilerComponent
						.getFcInterface("service");
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public ProcessDefinitionRegistry createRegistry(final String name,
			final Class<? extends AbstractProcessDefinitionRegistry> registryClass)
			throws CoreException {

		if (this.registryComponent != null) {
			throw new CoreException("Error: Registry already exist!!!");
		}

		ProcessDefinitionRegistry registry = null;
		this.registryComponent = FractalHelper.getFractalHelper()
				.createNewComponent(registryClass.getName(), null);
		FractalHelper.getFractalHelper().addComponent(this.registryComponent,
				this.component, null);

		try {
			registry = (ProcessDefinitionRegistry) this.registryComponent
					.getFcInterface("/content");
			(registry).init(this.registryComponent);
			if (!this.log.getName().equals(ModelImpl.class.getName())) {
				registry.setLog(this.log);
			}

			FractalHelper.getFractalHelper().startComponent(
					this.registryComponent);
			FractalHelper.getFractalHelper().changeName(this.registryComponent,
					name);

			registry = (ProcessDefinitionRegistry) this.registryComponent
					.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		this.log.finest("registry created and started");

		return registry;
	}

	public ProcessDefinitionRegistry getRegistry() throws CoreException {
		ProcessDefinitionRegistry res = null;
		try {
			if (this.registryComponent != null) {
				final Object obj = this.registryComponent.getFcInterface("service");
				res = (ProcessDefinitionRegistry) this.registryComponent
						.getFcInterface("service");
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

}
