/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.explorer;

import javax.swing.JOptionPane;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.explorer.FcExplorer;
import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.TreeView;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DeleteNodeProcessComponentAction implements MenuItem {

	// ==================================================================
	//
	// No internal state.
	//
	// ==================================================================

	// ==================================================================
	//
	// No constructor.
	//
	// ==================================================================

	// ==================================================================
	//
	// No internal method.
	//
	// ==================================================================

	// ==================================================================
	//
	// Public methods for ExtendedActionListener interface.
	//
	// ==================================================================

	public static int cpt = 0;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.objectweb.util.explorer.api.MenuItem#actionPerformed(org.objectweb.util.explorer.api.MenuItemTreeView)
	 */
	public void actionPerformed(final MenuItemTreeView e) {
		final Component ci = (Component) e.getSelectedObject();
		try {
			final Object itf = ci.getFcInterface("scope");
			if (itf instanceof Scope) {
				final Scope scope = (Scope) itf;
				final String name = JOptionPane
						.showInputDialog("Node name to delete:");
				final Node node = scope.getNodeByName(name);
				if (node instanceof Node) {
					scope.removeNode(node);
				}
			}
		} catch (final NoSuchInterfaceException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (final CoreException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.objectweb.util.explorer.api.MenuItem#getStatus(org.objectweb.util.explorer.api.TreeView)
	 */
	public int getStatus(final TreeView treeView) {
		final Component ci = (Component) treeView.getSelectedObject();
		try {
			final Object itf = ci.getFcInterface("scope");
			if (!(itf instanceof Scope)) {
				return MenuItem.NOT_VISIBLE_STATUS;
			}

			final LifeCycleController lcc = FcExplorer.getLifeCycleController(ci);
			final String status = lcc.getFcState();
			if (status.equals(LifeCycleController.STARTED)) {
				return MenuItem.ENABLED_STATUS;
			}
		} catch (final NoSuchInterfaceException e) {
			return MenuItem.NOT_VISIBLE_STATUS;
		}
		return MenuItem.NOT_VISIBLE_STATUS;
	}
}