/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.explorer.model;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.tools.DatedExternalMessage;

/**
 * 
 * @author Nico
 */
public class TableMessagesModel implements TableModel {

	private static final int sizeCol = 3;
	List<DatedExternalMessage> messages;

	/**
	 * Creates a new instance of TableFacturationModel
	 */
	public TableMessagesModel(final List<DatedExternalMessage> list) {
		this.messages = list;
		if (this.messages == null) {
			this.messages = new ArrayList<DatedExternalMessage>();
		}
	}

	public ExternalMessage getMessages(final int row) {
		return this.messages.get(row);
	}

	public int getRowCount() {
		return this.messages.size();
	}

	public int getColumnCount() {
		return TableMessagesModel.sizeCol;
	}

	public String getColumnName(final int columnIndex) {
		switch (columnIndex) {
		case 0:
			return "Date";
		case 1:
			return "Message";
		case 2:
			return "Replay";
		default:
			JOptionPane.showMessageDialog(null, "Erreur dans Table Message",
					"Error", JOptionPane.ERROR_MESSAGE);
		}
		return "";
	}

	public Class<?> getColumnClass(final int columnIndex) {
		if ((columnIndex == 1) || (columnIndex == 2)) {
			return JButton.class;
		}
		return String.class;
	}

	public boolean isCellEditable(final int rowIndex, final int columnIndex) {
		if ((columnIndex == 1) || (columnIndex == 2)) {
			return true;
		}
		return false;
	}

	public Object getValueAt(final int rowIndex, final int columnIndex) {
		switch (columnIndex) {
		case 0: {
			return this.messages.get(rowIndex).formatDate2String();
		}
		case 1: {
			return this.messages.get(rowIndex).getService();
		}
		case 2: {
			return "Replay";
		}
		default:
			JOptionPane.showMessageDialog(null, "Erreur dans Table Message",
					"Error", JOptionPane.ERROR_MESSAGE);
		}
		return "";
	}

	public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {

	}

	public void addTableModelListener(final TableModelListener l) {
	}

	public void removeTableModelListener(final TableModelListener l) {
	}

}
