/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.explorer.thread;

import org.objectweb.util.explorer.api.MenuItemTreeView;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class RunExecution extends Thread {

	private final Execution execution;
	private final MenuItemTreeView e;
	private long speedTime = 0;

	public RunExecution(final Execution execution, final MenuItemTreeView e,
			final long speedTime) {
		this.execution = execution;
		this.e = e;
		this.speedTime = speedTime;
	}

	@Override
	public void run() {
		RefreshExecution prefresh = null;
		try {
			prefresh = new RefreshExecution(this.e);
			this.execution.runSlowly(this.speedTime);
		} catch (final CoreException e) {
			e.printStackTrace();
		} finally {
			if (prefresh != null) {
				prefresh.setStop(true);
			}
		}
	}

}
