/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.monitoring.Monitor;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.monitoring.MonitorImpl;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.extensions.Membrane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@org.objectweb.fractal.fraclet.annotations.Interface(name="process", signature=Process.class)})
@Membrane(controller="composite")
public class ProcessImpl
extends ScopeImpl
implements Process {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ProcessImpl.class.getName());
    private ProcessKey key;
    private ExternalContext externalContext;
    private Monitor monitor = new MonitorImpl();
    private Process.State state = Process.State.PROCESS_INACTIVE;

    public void run() throws CoreException {
        this.log.finest("run process");
        if (this.state == Process.State.PROCESS_INACTIVE || this.state == Process.State.PROCESS_ENDED) {
            this.getMonitor().reset();
            this.getMonitor().setStartTime(Calendar.getInstance().getTime());
        }
        this.state = Process.State.PROCESS_ACTIVE;
        try {
            this.createParentExecution();
            this.log.finest("start parent execution");
            if (!FractalHelper.getFractalHelper().isStarted(this.parentExecution)) {
                FractalHelper.getFractalHelper().startComponent(this.parentExecution);
            }
            this.log.finest("parent execution started");
            this.log.finest("run the execution");
            Execution execution = (Execution)this.parentExecution.getFcInterface("service");
            execution.run();
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        this.log.finest("end of process");
    }

    public Execution createParentExecution() throws CoreException {
        Execution execution = null;
        try {
            if (this.parentExecution == null) {
                this.log.finest("create parent execution");
                this.parentExecution = FractalHelper.getFractalHelper().createNewComponent(ExecutionImpl.class.getName(), null);
                execution = (Execution)this.parentExecution.getFcInterface("/content");
                if (!this.log.getName().equals(ProcessImpl.class.getName())) {
                    execution.setLog(this.log);
                }
                FractalHelper.getFractalHelper().addComponent(this.parentExecution, this.getComponent(), null);
                FractalHelper.getFractalHelper().changeName(this.parentExecution, "mainExec");
                if (this.initialNode == null) {
                    throw new CoreException("Initial node not setted");
                }
                this.linkInitialNodeAndExecution();
            }
            execution = (Execution)this.parentExecution.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return execution;
    }

    public Map<String, Execution> getConcernedExecutions(InternalMessage<?> internalMessage) throws CoreException {
        HashMap<String, Execution> hashMap = new HashMap<String, Execution>();
        if (this.getParentExecution() != null) {
            hashMap.putAll(this.getConcernedExecutions(internalMessage, this.getParentExecution()));
            for (Scope scope : this.getAllScopes()) {
                hashMap.putAll(this.getConcernedExecutions(internalMessage, scope.getExecution()));
            }
        } else if (this.getParentExecution() == null) {
            Execution execution = this.createParentExecution();
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)execution, "service");
            FractalHelper.getFractalHelper().startComponent(component);
            try {
                if (!hashMap.containsKey(this.getParentExecution().getName())) {
                    hashMap.put(this.getParentExecution().getName(), this.getParentExecution());
                }
            }
            catch (CoreException coreException) {}
        }
        return hashMap;
    }

    private Map<String, Execution> getConcernedExecutions(InternalMessage<?> internalMessage, Execution execution) {
        Execution execution22;
        HashMap<String, Execution> hashMap = new HashMap<String, Execution>();
        if (execution != null) {
            for (Execution execution22 : execution.getChildExecutions()) {
                hashMap.putAll(this.getConcernedExecutions(internalMessage, execution22));
            }
        }
        if (execution != null && execution.getState().equals((Object)Execution.State.SUSPENDED) && execution.getCurrentTarget() != null && execution.getCurrentTarget() instanceof Node && (execution22 = (Node)execution.getCurrentTarget()).getBehaviour() instanceof ReceiverBehaviour) {
            try {
                if (!hashMap.containsKey(execution.getName())) {
                    hashMap.put(execution.getName(), execution);
                }
            }
            catch (CoreException coreException) {}
        }
        return hashMap;
    }

    public Engine getEngine() throws CoreException {
        Engine engine = null;
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.getComponent());
            engine = (Engine)component.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return engine;
    }

    @Override
    public Process getProcess() throws CoreException {
        return this;
    }

    public ProcessKey getProcessKey() {
        return this.key;
    }

    public void setProcessKey(ProcessKey processKey) {
        this.key = processKey;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void end(boolean bl) throws CoreException {
        super.end(bl);
        this.state = Process.State.PROCESS_ENDED;
        this.log.finest("PROCESS ENDED : " + this.getName());
        this.getMonitor().setEndTime(Calendar.getInstance().getTime());
        if (this.externalContext != null && this.externalContext.getTerminationHandler() != null) {
            this.externalContext.getTerminationHandler().end((Scope)this);
        }
    }

    public Process.State getState() {
        return this.state;
    }

    public void setState(Process.State state) {
        this.state = state;
    }

    @Override
    public String toString() {
        String string = super.toString();
        try {
            if (this.getName() != null) {
                string = this.getName();
            }
        }
        catch (CoreException coreException) {}
        return string;
    }
}

