/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.BreakpointBehaviour;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=BreakpointBehaviour.class)})
public class BreakpointBehaviourImpl
extends AbstractBehaviourImpl
implements BreakpointBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(BreakpointBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;

    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    public Map<String, Object> getInitializationContext() throws CoreException {
        return null;
    }

    public void setInitializationContext(Map<String, Object> map) throws CoreException {
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    public void executeActivity() throws CoreException {
        if (this.state == Behaviour.State.ACTIVITY_INACTIVE) {
            this.log.finest("start breakpoint behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_STARTED;
            this.log.finest("is debug mode? " + this.getNode().getExecution().getParentScope().isDebug());
            if (this.getNode().getExecution().getParentScope().isDebug()) {
                this.getNode().getExecution().setState(Execution.State.SUSPENDED);
                this.log.finest("breakpoint behaviour: suspend the execution " + this.getNode().getExecution().getName() + " => " + this.getNode().getExecution().getState());
                this.getNode().selectDefaultNextTarget();
            }
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    public String toString() {
        return "BreakpointActivity";
    }

    public Node getNode() {
        return this.node;
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }
}

