/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.SequenceBehaviour;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides={@org.objectweb.fractal.fraclet.annotations.Interface(name="service", signature=SequenceBehaviour.class)})
public class SequenceBehaviourImpl
extends AbstractBehaviourImpl
implements SequenceBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(SequenceBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;

    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    public Map<String, Object> getInitializationContext() throws CoreException {
        return null;
    }

    public void setInitializationContext(Map<String, Object> map) throws CoreException {
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    public void executeActivity() throws CoreException {
        if (this.state == Behaviour.State.ACTIVITY_INACTIVE) {
            this.log.finest("start sequence behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_STARTED;
            List list = this.node.getChildNodes();
            if (list != null && list.size() > 0) {
                Node node = null;
                for (Node node2 : list) {
                    Component component = FractalHelper.getFractalHelper().getComponentByInterface(FractalHelper.getFractalHelper().getParent(this.getComponent()), (Interface)node2, "service");
                    if (component != null && !FractalHelper.getFractalHelper().isStarted(component)) {
                        FractalHelper.getFractalHelper().startComponent(component);
                    }
                    if (node2.getIncomingTransitions() != null && (node2.getIncomingTransitions() == null || node2.getIncomingTransitions().size() != 0)) continue;
                    node = node2;
                    break;
                }
                this.getNode().getNextSelectedExecutableElements().add(node);
            }
        } else if (this.state == Behaviour.State.ACTIVITY_STARTED) {
            this.log.finest("end sequence behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
            this.getNode().getNextSelectedExecutableElements().clear();
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    public Node getNode() {
        return this.node;
    }

    public String toString() {
        return "Sequence";
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }
}

