/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.registry;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.registry.ProcessInstanceRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryProcessInstanceRegistryImpl
implements ProcessInstanceRegistry {
    private final Logger log = Logger.getLogger(MemoryProcessInstanceRegistryImpl.class.getName());
    private final Map<ProcessKey, List<Process>> map = new HashMap<ProcessKey, List<Process>>();
    private final Engine engine;

    public MemoryProcessInstanceRegistryImpl(Engine engine) {
        this.engine = engine;
    }

    public List<Process> getProcessInstances(InternalMessage<?> internalMessage) {
        ProcessKeyImpl processKeyImpl = new ProcessKeyImpl();
        processKeyImpl.setEndpoint(internalMessage.getEndpoint());
        processKeyImpl.setService(internalMessage.getService());
        return this.map.get(processKeyImpl);
    }

    public List<Process> getProcessInstances(ProcessKey processKey) {
        List<Process> list = this.map.get(processKey);
        if (list == null) {
            list = new ArrayList<Process>();
        }
        return list;
    }

    public Process removeProcessInstance(Process process, boolean bl) throws CoreException {
        ProcessKey processKey = process.getProcessKey();
        List<Process> list = this.map.get(processKey);
        Process process2 = null;
        if (list != null) {
            Iterator<Process> iterator = list.iterator();
            while (iterator.hasNext()) {
                process2 = iterator.next();
                if (!process2.getName().equals(process.getName())) continue;
                if (bl) {
                    list.remove(process2);
                    this.engine.deleteProcess(process2);
                    iterator = list.iterator();
                    break;
                }
                if (process2.getParentExecution() != null && process2.getParentExecution().getState() == Execution.State.ENDED || process2.getParentExecution() == null) {
                    list.remove(process2);
                    this.engine.deleteProcess(process2);
                    iterator = list.iterator();
                    break;
                }
                throw new CoreException("Impossible to remove this process instance (" + process2.getName() + ") because it is not ended: state = " + process2.getParentExecution().getState());
            }
        }
        return process2;
    }

    public void storeProcessInstance(ProcessKey processKey, Process process) throws CoreException {
        List<Process> list = this.map.get(processKey);
        if (list == null) {
            list = new ArrayList<Process>();
            this.map.put(processKey, list);
        }
        list.add(process);
        this.log.finest("instance stored: key = " + processKey + " - process: " + process.getName());
    }

    public Map<ProcessKey, List<Process>> getMap() {
        return this.map;
    }

    public List<Process> getProcessInstances() {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        for (List<Process> list : this.map.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }
}

