/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.thread.service;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.ServiceManager;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.AutoFlushMessageServiceImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.AutoTrashProcessServiceImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
implements ServiceManager {
    private Logger log = Logger.getLogger(ServiceManagerImpl.class.getName());
    private List<Service> services = new ArrayList<Service>();
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private Engine engine = null;

    public ServiceManagerImpl(Engine engine) throws CoreException {
        this.engine = engine;
        this.addService(AutoFlushMessageServiceImpl.class);
        this.addService(AutoTrashProcessServiceImpl.class);
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.services.size());
    }

    public void shutdownAllServices() {
        this.scheduledThreadPoolExecutor.shutdown();
        try {
            this.scheduledThreadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void restartAllServices() {
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.services.size());
        for (Service service : this.services) {
            this.scheduledThreadPoolExecutor.scheduleWithFixedDelay((Runnable)service, 0L, 1L, TimeUnit.MILLISECONDS);
        }
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void addService(Class<? extends Service> clazz) throws CoreException {
        Service service = this.findService(clazz);
        if (service != null) {
            this.log.warning("This service already exist: " + service);
        } else if (clazz != null) {
            this.log.fine("create service: " + clazz);
            Constructor<?> constructor = clazz.getConstructors()[0];
            try {
                Service service2 = (Service)constructor.newInstance(this.engine);
                this.services.add(service2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CoreException((Throwable)illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                throw new CoreException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CoreException((Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CoreException((Throwable)invocationTargetException);
            }
        }
    }

    private Service findService(Class<? extends Service> clazz) {
        Service service = null;
        for (Service service2 : this.services) {
            if (!service2.getClass().equals(clazz)) continue;
            service = service2;
            break;
        }
        return service;
    }

    public Service removeService(Class<? extends Service> clazz) {
        Service service = this.findService(clazz);
        if (service != null) {
            this.scheduledThreadPoolExecutor.remove((Runnable)service);
            this.scheduledThreadPoolExecutor.setCorePoolSize(this.services.size());
            this.services.remove(service);
        }
        return service;
    }

    public void activateService(Class<? extends Service> clazz) throws CoreException {
        Service service = this.findService(clazz);
        if (service != null) {
            this.log.finest("this service is activated: " + clazz.getSimpleName());
            this.scheduledThreadPoolExecutor.setCorePoolSize(this.services.size());
            this.scheduledThreadPoolExecutor.scheduleWithFixedDelay((Runnable)service, 0L, 1L, TimeUnit.MILLISECONDS);
        } else {
            this.log.warning("Impossible to find this service: " + clazz.getSimpleName());
        }
    }

    public <S extends Service> S getService(Class<S> clazz) {
        Service service = this.findService(clazz);
        return (S)service;
    }
}

