/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = ReceiverBehaviour.class))
public class ReceiverBehaviourImpl extends AbstractBehaviourImpl implements
ReceiverBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger
	.getLogger(ReceiverBehaviourImpl.class.getName());

	private InternalMessage<?> message;

	private List<QName> variableNames = new ArrayList<QName>();

	private MessageMatcher messageMatcher = null;

	private List<CorrelationMatcher> correlationsMatcher = null;

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;

	private Node childNodeSelected = null;

	private boolean isSuspended = false;


	
	public Map<String, Object> getInitializationContext()
	throws CoreException {
		final Map<String, Object> context = new HashMap<String, Object>();
		context.put("message", this.message);
		context.put("variableNames", this.variableNames);
		context.put("correlationsMatcher", this.correlationsMatcher);
		context.put("messageMatcher", this.messageMatcher);

		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
	throws CoreException {
		this.message = (InternalMessage<?>) context.get("message");
		this.variableNames = (List<QName>) context.get("variableNames");
		this.correlationsMatcher = (List<CorrelationMatcher>) context.get("correlationsMatcher");
		this.messageMatcher = (MessageMatcher) context.get("messageMatcher");

	}

	@Override
	public void executeActivity() throws CoreException {
		if ((this.state == State.ACTIVITY_INACTIVE)||(isSuspended == true)) {
			isSuspended = false;
			this.log.finest("execute receive behaviour on node: " + this.node.getName());
			this.state = State.ACTIVITY_STARTED;

			if (this.message != null) {
				final boolean accept = this.accept(this.message, this.getNode().getExecution()
						.getParentScope().getProcess().getExternalContext());
				if (accept) {
					this.log.finest("Message accepted by the received activity: "
							+ this.getName());

					if (this.getChildNodeSelected() != null) {
						this.getNode().getNextSelectedExecutableElements().add(
								this.getChildNodeSelected());
					} 
				} else {
					this.getNode().getExecution().setStateRecursively(
							Execution.State.SUSPENDED);
					isSuspended = true;
					this.log
					.finest("Message does not correspond - execution suspended: "
							+ this.getNode().getExecution().getState());
					this.getNode().getNextSelectedExecutableElements().add(
							this.getNode());
				}
				this.message = null;
			} else {
				this.getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
				isSuspended = true;
				this.log.finest("No Message - execution suspended: "
						+ this.getNode().getExecution().getState());
				this.getNode().getNextSelectedExecutableElements().add(
						this.getNode());
			}
		} else if (this.state == State.ACTIVITY_STARTED) {
			this.log
			.finest("end receive behaviour on node: "
					+ this.node.getName());
			this.state = State.ACTIVITY_ENDED;
			this.log.finest("received activity ended");
			this.setMessage(null);
			this.childNodeSelected = null;
			this.getNode().getNextSelectedExecutableElements().clear();
		}
	}

	@Override
	public String toString() {
		return "Receive Behaviour";
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	public boolean accept(final InternalMessage<?> message, final ExternalContext context)
	throws CoreException {
		boolean accept = false;
		this.log.finest("Message receive on node: " + this.node.getName());

		// get the variable in process
		final Scope scope = this.node.getExecution().getParentScope();

		int cptChild = 0;
		for (final QName variableName : this.getVariableNames()) {
			final Variable v = scope.findVariable(variableName);
			if (v == null) {
				throw new CoreException(
						"Impossible to find in process, the variable used in the received : "
						+ this.getName());
			}

			// check the message
			boolean check = false;
			if (this.getMessageMatcher() != null) {
				check = this.getMessageMatcher().match(v, message);
			} else {
				this.log.warning("no matcher found");
				check = true;
			}

			if(!check) {
				log.finest("message not valid for variable: " + variableName);
			} else {

				boolean correlationOK = false;
				if(this.correlationsMatcher != null) {
					log.finest("Correlation found: execute correlation for receiver: " + this.getName());
					for(CorrelationMatcher corr: this.correlationsMatcher) {
						correlationOK = corr.match(scope, variableName, message);
						if(correlationOK) {
							break;
						}
					}
				} else {
					log.finest("No correlation ");
					correlationOK = true;
				}

				if ((check)&&(correlationOK)) {
					// set the message
					v.setValue(message);

					// valid the accept
					accept = true;
					this.log.finest("Message accepted on receive by variable: "
							+ variableName);
					if (this.node.getChildNodes().size() > 0) {
						this.childNodeSelected = this.node.getChildNodes().get(
								cptChild);
					}
					break;
				}
			}
			cptChild++;
		}

		return accept;
	}

	public List<QName> getVariableNames() {
		if (this.variableNames == null) {
			this.variableNames = new ArrayList<QName>();
		}
		return this.variableNames;
	}

	public void addVariableName(final QName variableName) {
		this.getVariableNames().add(variableName);
	}

	public void setMessage(final InternalMessage<?> message) {
		this.message = message;
	}

	public InternalMessage<?> getMessage() {
		return this.message;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	public Node getChildNodeSelected() {
		return this.childNodeSelected;
	}

	public List<CorrelationMatcher> getCorrelationsMatchers() {
		return this.correlationsMatcher;
	}

	public void setCorrelationsMatchers(List<CorrelationMatcher> correlationMatcher) {
		this.correlationsMatcher = correlationMatcher;
	}

	public MessageMatcher getMessageMatcher() {
		return this.messageMatcher;
	}

	public void setMessageMatcher(MessageMatcher messageMatcher) {
		this.messageMatcher = messageMatcher;
	}

//	public boolean getCreateInstance() {
//		
//		return this.createInstance;
//		
//	}
//
//	public void setCreateInstance(boolean createInstance) {
//		this.createInstance = createInstance;
//	}

}
