/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ThrowBehaviour;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = ThrowBehaviour.class))
public class ThrowBehaviourImpl extends AbstractBehaviourImpl implements ThrowBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ThrowBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;

	private Exception exception;

	public ThrowBehaviourImpl() {
	}

	public Map<String, Object> getInitializationContext()
			throws CoreException {
		final Map<String, Object> context = new HashMap<String, Object>();
		context.put("exception", this.exception);
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
			throws CoreException {
		this.exception = (CoreException) context.get("exception");
	}

	@Override
	public void executeActivity() throws CoreException {
		this.log.finest("start throw behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;
		
		if(exception == null) {
			throw new CoreException("Exception cannot be null");
		}
		
		this.log.finest("execute throw behaviour: " + this.exception.getClass());
		if(!(this.exception instanceof CoreException)) {
			throw new CoreException(this.exception);
		} else {
			throw (CoreException)this.exception;
		}
	}

	@Override
	public String toString() {
		return "ThrowActivity";
	}

	public Exception getException() {
		return this.exception;
	}

	public void setException(final Exception exception) {
		this.exception = exception;
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

}