/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.DateExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component(provides = @Interface(name = "service", signature = WaitBehaviour.class))
public class WaitBehaviourImpl extends AbstractBehaviourImpl implements WaitBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(WaitBehaviourImpl.class.getName());

	@Requires(name = "node", contingency = Contingency.OPTIONAL)
	protected Node node;

	private LongExpression<?> time;

	private DateExpression<?> date;

	public WaitBehaviourImpl() {

	}

	public Map<String, Object> getInitializationContext()
	throws CoreException {
		final Map<String, Object> context = new HashMap<String, Object>();
		context.put("time", this.time);
		context.put("date", this.date);
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
	throws CoreException {
		this.time = ((LongExpression) context.get("time"));
		this.date = ((DateExpression) context.get("date"));
	}

	@Override
	public void executeActivity() throws CoreException {
		this.log.finest("start wait behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;

		try {
			if(this.time != null) {
				Long time = this.time.evaluate(this.getNode().getExecution().getParentScope());
				if(time == null) {
					throw new CoreException("Impossible to evaluate long expression: " + this.time.getContent());
				}
				this.log.finest("execute wait behaviour on node: " + this.node.getName()
						+ " => wait during " + time + " ms");
				Thread.currentThread().sleep(time);

				this.log.finest("wait finished");
			} else if(this.date != null) {
				try {
					Date date = this.date.evaluate(this.getNode().getExecution().getParentScope());
					if(date == null) {
						throw new CoreException("Impossible to evaluate date expression: " + this.date.getContent());
					}
					this.log.finest("execute wait behaviour on node: " + this.node.getName()
							+ " => wait until " + date );
					Thread.currentThread().sleep(date.getTime() - System.currentTimeMillis());
				} catch(IllegalArgumentException e) {
					this.log.warning("wait behaviour: " + e.getMessage());
				}
				this.log.finest("wait finished");
			}
		} catch (final InterruptedException e) {
			throw new CoreException(e);
		}
	}

	public LongExpression<?> getDuration() {
		return this.time;
	}

	public void setDuration(final LongExpression<?> time) {
		this.time = time;
	}

	public DateExpression<?> getDate() {
		return this.date;
	}

	public void setDate(DateExpression<?> date) {
		this.date = date;
	}

	@Override
	public Node getNode() {
		return this.node;
	}

	@Override
	public String toString() {
		return "WaitActivity";
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}


}