/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.registry.ProcessInstanceRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class MemoryProcessInstanceRegistryImpl implements ProcessInstanceRegistry {

	private final Logger log = Logger
	.getLogger(MemoryProcessInstanceRegistryImpl.class.getName());

	private final Map<ProcessKey, List<Process>> map = new HashMap<ProcessKey, List<Process>>();

	private final Engine engine;

	public MemoryProcessInstanceRegistryImpl(final Engine engine) {
		this.engine = engine;
	}

	public List<Process> getProcessInstances(final InternalMessage<?> message) {
		final ProcessKey key = new ProcessKeyImpl();
		key.setEndpoint(message.getEndpoint());
		key.setService(message.getService());
		

		this.log.finest("tried key : "+ key.toString());
		//TODO to remove when stable
		String keys = null;
		Iterator<ProcessKey> it = this.map.keySet().iterator();
		while(it.hasNext()){
			if(keys == null) {
				keys = it.next().toString();
			} else {
				keys = keys + ", " + it.next().toString();
			}
		}

		this.log.finest("available keys : " + keys);
		//END TODO

		return this.map.get(key);
	}

	public List<Process> getProcessInstances(final ProcessKey key) {
		List<Process> res = this.map.get(key);
		if (res == null) {
			res = new ArrayList<Process>();
		}
		return res;
	}

	public Process removeProcessInstance(final Process process, boolean forceUninstall)
	throws CoreException {

		final List<ProcessKey> keys = process.getProcessKeys();

		for(ProcessKey key : keys){

			final List<Process> processes = this.map.get(key);

			Process p = null;
			if(processes != null) {
				Iterator<Process> it = processes.iterator();
				while (it.hasNext()) {
					p = it.next();
					if (p.getName().equals(process.getName())) {
						if(forceUninstall) {
							// delete in map
							processes.remove(p);
							this.engine.deleteProcess(p);
							it = processes.iterator();
						} else if (((p.getParentExecution() != null) && (p
								.getParentExecution().getState() == Execution.State.ENDED))
								|| (p.getParentExecution() == null)) {
							// delete in map
							processes.remove(p);
							this.engine.deleteProcess(p);
							it = processes.iterator();
						} else {
							throw new CoreException(
									"Impossible to remove this process instance ("
									+ p.getName()
									+ ") because it is not ended: state = "
									+ p.getParentExecution().getState());
						}

						break;
					}
				}
			}else{
				this.log.finest("processes IS NULL ...");
			}

			List<Process> processesCleaned = this.map.get(key);
			if((processesCleaned == null) || (processesCleaned.size() == 0)){
				this.map.remove(key);
			}

		}



		return process;
	}

	public void storeProcessInstance(final ProcessKey key, final Process process)
	throws CoreException {
		List<Process> processNames = this.map.get(key);

		if (processNames == null) {
			processNames = new ArrayList<Process>();
			this.map.put(key, processNames);
		}
		processNames.add(process);

		this.log.finest("instance stored: key = " + key + " - process: "
				+ process.getName());
		this.log.finest("Number of process in key \"" + key + "\" : " + processNames.size());
	}

	public Map<ProcessKey, List<Process>> getMap() {
		return this.map;
	}

	public List<Process> getProcessInstances() {
		List<Process> res = new ArrayList<Process>();
		for(List<Process> processes: this.map.values()) {
			for(Process process : processes){
				if(!res.contains(process)){
					res.add(process);						
				}
			}
		}
		return res;
	}



}
