/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.thread.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AutoFlushMessageService;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;

public class AutoFlushMessageServiceImpl extends AbstractServiceImpl implements AutoFlushMessageService {

	private Logger log = Logger.getLogger(AutoFlushMessageServiceImpl.class.getName());

	private final Map<QName, List<Map<InternalMessage, ExternalContext>>> messageRegistry = Collections.synchronizedMap(new HashMap<QName, List<Map<InternalMessage, ExternalContext>>>());

	public AutoFlushMessageServiceImpl(Engine engine) {
		super(engine);
	}

	public void run() {
		try {

			flushMessagesInRegistry();
			Thread.sleep(this.getRefreshFrequency());

		} catch (Exception e) {
			e.printStackTrace();
			log.severe("Error in auto trash service: " + e.getMessage());
		} 	
	}

	public void flushMessagesInRegistry() throws CoreException {
		this.log.finest("flush stored messages");
		List<Map<InternalMessage, ExternalContext>> allMsgs = new ArrayList<Map<InternalMessage, ExternalContext>>();
		for (final List<Map<InternalMessage, ExternalContext>> list : this.messageRegistry
				.values()) {
			allMsgs.addAll(list);
		}
		this.messageRegistry.clear();

		Iterator<Map<InternalMessage, ExternalContext>> itAllMsgs = allMsgs.iterator();
		while(itAllMsgs.hasNext()) {
			Map<InternalMessage, ExternalContext> msgMap = itAllMsgs.next();
			Iterator<Entry<InternalMessage, ExternalContext>> msgs = msgMap.entrySet().iterator();
			while(msgs.hasNext()) {
				Entry<InternalMessage, ExternalContext> entry = msgs.next();
				this.getEngine().accept(entry.getKey(), entry
						.getValue());
			}
		}
	}



	public void addMessagesInRegistry(InternalMessage internalMessage, ExternalContext context) {
		List<Map<InternalMessage, ExternalContext>> msgs = this.messageRegistry
		.get(internalMessage.getQName());
		if (msgs == null) {
			msgs = new ArrayList<Map<InternalMessage, ExternalContext>>();
		}
		final Map<InternalMessage, ExternalContext> map = new HashMap<InternalMessage, ExternalContext>();
		map.put(internalMessage, context);
		msgs.add(map);
		this.messageRegistry.put(internalMessage.getQName(), msgs);
	}



}
