/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.thread.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Process.State;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AutoTrashProcessService;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;

public class AutoTrashProcessServiceImpl extends AbstractServiceImpl implements AutoTrashProcessService {

	private static final int NUMBER_OF_CLEAN_BEFORE_DELETING = 2;

	private Logger log = Logger.getLogger(AutoTrashProcessServiceImpl.class.getName());

	private final List<TrashProcessInstance> list = Collections.synchronizedList(new ArrayList<TrashProcessInstance>());



	public AutoTrashProcessServiceImpl(Engine engine) {
		super(engine);
	}

	public void run() {
		try {

			tryToEndAllProcessIntances();
			Thread.sleep(this.getRefreshFrequency());

		} catch (Exception e) {
			e.printStackTrace();
			log.severe("Error in auto trash service: " + e.getMessage());
		} 
	}

	public void tryToEndAllProcessIntances() {
		List<TrashProcessInstance> process = new ArrayList<TrashProcessInstance>();
		process.addAll(this.list);

		this.list.clear();

		Iterator<TrashProcessInstance> it = process.iterator();
		while(it.hasNext()) {
			TrashProcessInstance p = it.next();
			try {
				if(p.getNumberOfClean() == NUMBER_OF_CLEAN_BEFORE_DELETING) {
					log.warning("try to delete instance: " + p.getProcessInstance().getName());
					FractalHelper.getFractalHelper().stopComponent(p.getProcessInstance().getComponent());
					FractalHelper.getFractalHelper().deleteComponent(p.getProcessInstance().getComponent());
				} else {
					log.warning("try to clean instance: " + p.getProcessInstance().getName());
					p.getProcessInstance().end(true);
					List<ProcessKey> keys = p.getProcessInstance().getProcessKeys();
					for(ProcessKey key : keys){
						List<Process> listP = ((MemoryProcessInstanceRegistryImpl)this.getEngine().getProcessInstanceRegistry()).getMap().get(key);
						if(listP == null) {
							listP = new ArrayList<Process>();
						}
						listP.add(p.getProcessInstance());
						((MemoryProcessInstanceRegistryImpl)this.getEngine().getProcessInstanceRegistry()).getMap().put(key, listP);
					}
				}
			} catch (CoreException e) {
				p.setNumberOfClean(p.getNumberOfClean() + 1);
				try {
					log.warning("impossible to ended this instance: " + p.getProcessInstance().getName());
				} catch (CoreException e1) {
					// do nothing
				}
				this.list.add(p);
			}
		}
	}

	public void addUninstableProcessInstance(Process p) {
		if(p.getState().equals(State.PROCESS_UNSTABLE)) {
			this.list.add(new TrashProcessInstance(p));
		}
	}


	private class TrashProcessInstance {

		private int numberOfClean = 0;

		private Process processInstance = null;

		public TrashProcessInstance(Process processInstance) {
			this.processInstance = processInstance;
		}

		public int getNumberOfClean() {
			return numberOfClean;
		}

		public void setNumberOfClean(int numberOfClean) {
			this.numberOfClean = numberOfClean;
		}

		public Process getProcessInstance() {
			return processInstance;
		}


	}
}
