/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.model.registry;

import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;

public class ProcessContextDefinitionImpl implements ProcessContextDefinition{


	int _poolsize;

	private static final int MAX_POOL_SIZE = 1000;

	private final Logger log = Logger
	.getLogger(ProcessContextDefinitionImpl.class.getName());

	public ProcessContextDefinitionImpl(int poolsize){

		if(poolsize < 1){
		
			this.log.warning("Minimum value for pool size is 1. Got " + poolsize);
			_poolsize = 1;
		
		}else if(poolsize > MAX_POOL_SIZE){
		
			this.log.warning("Maximum size reached for pool size: " + MAX_POOL_SIZE);
			_poolsize = MAX_POOL_SIZE;
		
		}else {	
			_poolsize = poolsize;
		}
	}
	public ProcessContextDefinitionImpl(){
		//TODO Check that set poolsize to 1 doesn't affect processes execution
		_poolsize = 1;
	}

	public int getPoolSize() {
		return _poolsize;
	}

	public void setPoolSize(int ps) {
		_poolsize = ps;

	}
}
