/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.soa.message;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageConverter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageFactory;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class IdenticalMessageConverterImpl<E extends ExternalMessage<T>, I extends InternalMessage<T>, T>
		implements MessageConverter<E, I> {

	Class<I> iImpl;

	Class<E> eImpl;

	public IdenticalMessageConverterImpl(
			final Class<? extends ExternalMessage> class1,
			final Class<? extends InternalMessage> class2) {
		this.iImpl = (Class<I>) class2;
		this.eImpl = (Class<E>) class1;
	}

	public E createExternalMessageFromInternalMessage(final I internalMessage)
			throws CoreException {
		E externalMessage = null;
		if (internalMessage != null) {
			try {
				final Constructor<?> c = this.eImpl.getConstructors()[0];
				externalMessage = (E) c.newInstance();
				externalMessage.setContent(internalMessage.getContent());
				externalMessage.setQName(internalMessage.getQName());
				externalMessage.setEndpoint(internalMessage.getEndpoint());
				externalMessage.setService(internalMessage.getService());
				externalMessage.setOperationName(internalMessage
						.getOperationName());
			} catch (final IllegalArgumentException e) {
				throw new CoreException(e);
			} catch (final InstantiationException e) {
				throw new CoreException(e);
			} catch (final IllegalAccessException e) {
				throw new CoreException(e);
			} catch (final InvocationTargetException e) {
				throw new CoreException(e);
			}
		}
		return externalMessage;
	}

	public I createInternalMessageFromExternalMessage(final E externalMessage)
			throws CoreException {
		I internalMessage = null;
		if (externalMessage != null) {
			try {
				final Constructor c = this.iImpl.getConstructors()[0];
				internalMessage = (I) c.newInstance();
				internalMessage.setContent(externalMessage.getContent());
				internalMessage.setQName(externalMessage.getQName());
				internalMessage.setEndpoint(externalMessage.getEndpoint());
				internalMessage.setService(externalMessage.getService());
				internalMessage.setOperationName(externalMessage
						.getOperationName());
			} catch (final IllegalArgumentException e) {
				throw new CoreException(e);
			} catch (final InstantiationException e) {
				throw new CoreException(e);
			} catch (final IllegalAccessException e) {
				throw new CoreException(e);
			} catch (final InvocationTargetException e) {
				throw new CoreException(e);
			}
		}
		return internalMessage;
	}

	public Class<E> getExternalMessageType() {
		return this.eImpl;
	}

	public Class<I> getInternalMessageType() {
		return this.iImpl;
	}

	public MessageFactory<ExternalMessage<?>, InternalMessage<?>> getMessageFactory() {
		return new MessageFactoryImpl(this.iImpl, this.eImpl);
	}

}
