package com.ebmwebsourcing.easyviper.core.impl.soa.message;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageFactory;

public class MessageFactoryImpl implements MessageFactory<ExternalMessage<?>, InternalMessage<?>> {

	private Class<? extends InternalMessage<?>> internalMsgClass;
	
	private Class<? extends ExternalMessage<?>> externalMsgClass;
	
	public MessageFactoryImpl(Class<? extends InternalMessage<?>> internalMsgClass, Class<? extends ExternalMessage<?>> externalMsgClass) {
		this.internalMsgClass = internalMsgClass;
		this.externalMsgClass = externalMsgClass;
	}
	
	public ExternalMessage<?> createExternalMessage() throws CoreException {
		ExternalMessage<?> res = null;
		try {
			final Constructor<?> c = this.externalMsgClass.getConstructors()[0];
			res =  (ExternalMessage<?>) c.newInstance();
		} catch (final IllegalArgumentException e) {
			throw new CoreException(e);
		} catch (final InstantiationException e) {
			throw new CoreException(e);
		} catch (final IllegalAccessException e) {
			throw new CoreException(e);
		} catch (final InvocationTargetException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public InternalMessage<?> createInternalMessage() throws CoreException  {
		InternalMessage<?> res = null;
		try {
			final Constructor<?> c = this.internalMsgClass.getConstructors()[0];
			res =  (InternalMessage<?>) c.newInstance();
		} catch (final IllegalArgumentException e) {			
			throw new CoreException(e);
		} catch (final InstantiationException e) {
			throw new CoreException(e);
		} catch (final IllegalAccessException e) {
			throw new CoreException(e);
		} catch (final InvocationTargetException e) {
			throw new CoreException(e);
		}
		return res;
	}

}
