/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.explorer.model;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;

import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.explorer.panel.EditMessages;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiver;

/**
 * 
 * @author Nico
 */
public class TableMessagesButtonEditor extends JButton implements
		TableCellEditor {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	protected EventListenerList listenerL = new EventListenerList();

	protected ChangeEvent changeE = new ChangeEvent(this);

	private JTable t = null;

	private MemoryReceiver receiver = null;

	private int ligne = -1;
	private int col = -1;

	/** Creates a new instance of CollaborateurClientButtonEditor */
	public TableMessagesButtonEditor(final JTable t, final MemoryReceiver receiver1) {
		super();
		this.t = t;
		this.receiver = receiver1;

		this.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				if (TableMessagesButtonEditor.this.col == 1) {
					final EditMessages msg = new EditMessages(TableMessagesButtonEditor.this.receiver.getMessages()
							.get(TableMessagesButtonEditor.this.ligne));
					msg.setVisible(true);
				} else if (TableMessagesButtonEditor.this.col == 2) {
					try {
						TableMessagesButtonEditor.this.receiver
								.accept(TableMessagesButtonEditor.this.receiver.getMessages().get(TableMessagesButtonEditor.this.ligne), null);
						t.setModel(new TableMessagesModel(TableMessagesButtonEditor.this.receiver
								.getMessages()));

						final TableMessagesButtonRenderer tmbr = new TableMessagesButtonRenderer();
						t.setDefaultRenderer(JButton.class, tmbr);

						final TableMessagesButtonEditor tmbe = new TableMessagesButtonEditor(
								t, TableMessagesButtonEditor.this.receiver);

						final TableColumn openButton = t.getColumnModel()
								.getColumn(1);
						openButton.setCellRenderer(tmbr);
						openButton.setCellEditor(tmbe);

						final TableColumn replayButton = t.getColumnModel()
								.getColumn(2);
						replayButton.setCellRenderer(tmbr);
						replayButton.setCellEditor(tmbe);
					} catch (final CoreException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}
			}
		});
	}

	public Component getTableCellEditorComponent(final JTable table,
			final Object value, final boolean isSelected, final int row,
			final int column) {
		this.ligne = row;
		this.col = column;
		if (column == 1) {
			this.setText(value.toString());
		} else if (column == 2) {
			this.setText("Replay");
		}

		return this;
	}

	public Object getCellEditorValue() {
		return this;
	}

	public boolean isCellEditable(final EventObject anEvent) {
		return true;
	}

	public boolean shouldSelectCell(final EventObject anEvent) {
		return true;
	}

	public boolean stopCellEditing() {
		return true;
	}

	public void cancelCellEditing() {
	}

	public void addCellEditorListener(final CellEditorListener l) {
		this.listenerL.add(CellEditorListener.class, l);
	}

	public void removeCellEditorListener(final CellEditorListener l) {
		this.listenerL.remove(CellEditorListener.class, l);
	}

}
