/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.explorer.panel;

import javax.swing.DefaultComboBoxModel;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.api.MenuItemTreeView;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class EditBehaviour extends javax.swing.JFrame {

	private Scope scope;

	private Behaviour behaviour;

	private MenuItemTreeView e;

	/**
	 * Constructeur to edit a new node
	 */
	public EditBehaviour(final MenuItemTreeView e, final Component componentBehaviour) {
		this.initComponents();
		this.setTitle("Edit Behaviour");
		try {
			if (!FractalHelper.getFractalHelper().isStarted(componentBehaviour)) {
				FractalHelper.getFractalHelper().startComponent(
						componentBehaviour);
			}

			final Component scopeParent = FractalHelper.getFractalHelper().getParent(
					componentBehaviour);
			this.scope = (Scope) scopeParent.getFcInterface("service");
			this.e = e;

			this.behaviour = (Behaviour) componentBehaviour
					.getFcInterface("service");

			this.jComboBoxBehaviour.setModel(new DefaultComboBoxModel());
			((DefaultComboBoxModel) this.jComboBoxBehaviour.getModel())
					.addElement(this.behaviour.getName());

			if (this.behaviour instanceof IfBehaviour) {
				this.jTextAreaExpression.setVisible(true);
				final IfBehaviour ifBehaviour = (IfBehaviour) this.behaviour;
				if ((ifBehaviour.getConditions() != null)
						&& (ifBehaviour.getConditions().size() > 0)) {
					this.jTextAreaExpression.setText(ifBehaviour
							.getConditions().get(0).getContent().toString());
				}
			} else {
				this.jTextAreaExpression.setVisible(false);
			}

		} catch (final CoreException ex) {
			// TODO Auto-generated catch block
			ex.printStackTrace();
		} catch (final NoSuchInterfaceException ex) {
			// TODO Auto-generated catch block
			ex.printStackTrace();
		}
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc="Generated
	// Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		this.jLabel1 = new javax.swing.JLabel();
		this.jComboBoxBehaviour = new javax.swing.JComboBox();
		this.jLabel2 = new javax.swing.JLabel();
		this.jButtonSave = new javax.swing.JButton();
		this.jScrollPaneBehaivour = new javax.swing.JScrollPane();
		this.jTextAreaExpression = new javax.swing.JTextArea();

		this.setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

		this.jLabel1.setText("Kind of Behaviour:");

		this.jComboBoxBehaviour.setModel(new javax.swing.DefaultComboBoxModel(
				new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

		this.jLabel2.setText("Expression:");

		this.jButtonSave.setText("OK");
		this.jButtonSave.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(final java.awt.event.ActionEvent evt) {
				EditBehaviour.this.jButtonSaveActionPerformed(evt);
			}
		});

		this.jTextAreaExpression.setColumns(20);
		this.jTextAreaExpression.setRows(5);
		this.jScrollPaneBehaivour.setViewportView(this.jTextAreaExpression);

		final org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
				this.getContentPane());
		this.getContentPane().setLayout(layout);
		layout
				.setHorizontalGroup(layout
						.createParallelGroup(
								org.jdesktop.layout.GroupLayout.LEADING)
						.add(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.LEADING)
														.add(
																org.jdesktop.layout.GroupLayout.TRAILING,
																this.jButtonSave)
														.add(
																layout
																		.createSequentialGroup()
																		.add(
																				this.jLabel1)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED)
																		.add(
																				this.jComboBoxBehaviour,
																				0,
																				288,
																				Short.MAX_VALUE))
														.add(
																layout
																		.createSequentialGroup()
																		.add(
																				this.jLabel2)
																		.add(
																				36,
																				36,
																				36)
																		.add(
																				this.jScrollPaneBehaivour,
																				org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																				288,
																				Short.MAX_VALUE)))
										.addContainerGap()));
		layout
				.setVerticalGroup(layout
						.createParallelGroup(
								org.jdesktop.layout.GroupLayout.LEADING)
						.add(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(this.jLabel1)
														.add(
																this.jComboBoxBehaviour,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
										.add(72, 72, 72)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.LEADING)
														.add(
																this.jScrollPaneBehaivour,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
														.add(this.jLabel2)).add(76,
												76, 76).add(this.jButtonSave)
										.addContainerGap()));

		this.pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jButtonSaveActionPerformed(final java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonSaveActionPerformed
		// TODO add your handling code here:
		if (this.behaviour instanceof IfBehaviour) {
			final IfBehaviour ifBehaviour = (IfBehaviour) this.behaviour;
			if ((ifBehaviour.getConditions() != null)
					&& (ifBehaviour.getConditions().size() > 0)) {
				ifBehaviour.getConditions().get(0).setContent(
						this.jTextAreaExpression.getText());
			}
		}
		this.setVisible(false);

	}// GEN-LAST:event_jButtonSaveActionPerformed

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(final String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new EditBehaviour(null, null).setVisible(true);
			}
		});
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButtonSave;
	private javax.swing.JComboBox jComboBoxBehaviour;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JScrollPane jScrollPaneBehaivour;
	private javax.swing.JTextArea jTextAreaExpression;
	// End of variables declaration//GEN-END:variables

}
