/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.explorer.panel;

import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.util.explorer.api.MenuItemTreeView;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class EditNode extends javax.swing.JFrame {

	private Scope scope;

	private Node node;

	private Map<String, Component> incomingTransitions;

	private Map<String, Component> outgoingNode;

	private MenuItemTreeView e;

	private EditBehaviour editBehaviour;

	/**
	 * Constructeur to create a new node
	 */
	public EditNode(final MenuItemTreeView e, final Scope scope) {
		this.initComponents();
		try {
			this.scope = scope;
			this.e = e;
			this.jTextFieldNodeName.setText("node"
					+ this.scope.getAllNodes().size());

			// this.jComboBoxNodeBehaviour.setModel(new
			// DefaultComboBoxModel(DefaultBehaviour.getDefaultBehaviour().toArray()));
			this.jListIncomingTransition.setModel(new DefaultListModel());
			this.jListOutgoingNode.setModel(new DefaultListModel());

			this.incomingTransitions = new HashMap<String, Component>();
			for (final Transition t : this.scope.getAllTransitions()) {
				final Component c = FractalHelper.getFractalHelper()
						.getComponentByInterface(this.scope.getComponent(),
								(Interface) t, "service");
				this.incomingTransitions.put(FractalHelper.getFractalHelper()
						.getName(c), c);
			}

			this.jComboBoxIncomingTransition.setModel(new DefaultComboBoxModel(
					this.incomingTransitions.keySet().toArray()));

			this.outgoingNode = new HashMap<String, Component>();
			for (final Node n : this.scope.getAllNodes()) {
				final Component c = FractalHelper.getFractalHelper()
						.getComponentByInterface(this.scope.getComponent(),
								(Interface) n, "service");
				this.outgoingNode
						.put(FractalHelper.getFractalHelper().getName(c), c);
			}

			this.jComboBoxOutgoingNode.setModel(new DefaultComboBoxModel(
					this.outgoingNode.keySet().toArray()));

		} catch (final CoreException ex) {
			// TODO Auto-generated catch block
			ex.printStackTrace();
		}
	}

	/**
	 * Constructeur to edit a new node
	 */
	public EditNode(final MenuItemTreeView e, final Component componentNode) {
		this.initComponents();
		try {
			

			if (!FractalHelper.getFractalHelper().isStarted(componentNode)) {
				FractalHelper.getFractalHelper().startComponent(componentNode);
			}

			final Component scopeParent = FractalHelper.getFractalHelper().getParent(
					componentNode);
			

			this.scope = (Scope) scopeParent.getFcInterface("service");
			this.node = (Node) componentNode.getFcInterface("service");
			this.e = e;
			this.jTextFieldNodeName.setText(FractalHelper.getFractalHelper()
					.getName(componentNode));

			// start behaviour
			
			final Component componentBehaviour = FractalHelper.getFractalHelper()
					.getComponentByInterface(this.scope.getComponent(),
							(Interface) this.node.getBehaviour(), "service");
			if (!FractalHelper.getFractalHelper().isStarted(componentBehaviour)) {
				FractalHelper.getFractalHelper().startComponent(
						componentBehaviour);
			}

			

			this.jTextFieldBehaviour.setText(this.node.getBehaviour().getName());

			this.jListIncomingTransition.setModel(new DefaultListModel());
			for (final Transition t : this.node.getIncomingTransitions()) {
				((DefaultListModel) this.jListIncomingTransition.getModel())
						.addElement(t);
			}

			this.jListOutgoingNode.setModel(new DefaultListModel());
			
			for (final Transition t : this.node.getOutgoingTransitions()) {
				((DefaultListModel) this.jListOutgoingNode.getModel())
						.addElement(t);
			}

			this.incomingTransitions = new HashMap<String, Component>();
			for (final Transition t : this.scope.getAllTransitions()) {
				final Component c = FractalHelper.getFractalHelper()
						.getComponentByInterface(this.scope.getComponent(),
								(Interface) t, "service");
				this.incomingTransitions.put(FractalHelper.getFractalHelper()
						.getName(c), c);
			}

			this.jComboBoxIncomingTransition.setModel(new DefaultComboBoxModel(
					this.incomingTransitions.keySet().toArray()));

			this.outgoingNode = new HashMap<String, Component>();
			for (final Node n : this.scope.getAllNodes()) {
				final Component c = FractalHelper.getFractalHelper()
						.getComponentByInterface(this.scope.getComponent(),
								(Interface) n, "service");
				this.outgoingNode
						.put(FractalHelper.getFractalHelper().getName(c), c);
			}

			this.jComboBoxOutgoingNode.setModel(new DefaultComboBoxModel(
					this.outgoingNode.keySet().toArray()));

		} catch (final Exception ex) {
			// TODO Auto-generated catch block
			ex.printStackTrace();
		}
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc="Generated
	// Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		this.jLabelNodeName = new javax.swing.JLabel();
		this.jTextFieldNodeName = new javax.swing.JTextField();
		this.jLabelNodeBehaviour = new javax.swing.JLabel();
		this.jLabelIncomingTransition = new javax.swing.JLabel();
		this.jLabelSelectIncomingTransition = new javax.swing.JLabel();
		this.jComboBoxIncomingTransition = new javax.swing.JComboBox();
		this.jButtonAddIncomingTransition = new javax.swing.JButton();
		this.jScrollPaneIncomingTransition = new javax.swing.JScrollPane();
		this.jListIncomingTransition = new javax.swing.JList();
		this.jLabelOutgoingNode = new javax.swing.JLabel();
		this.jLabelSelectOutgoingNode = new javax.swing.JLabel();
		this.jComboBoxOutgoingNode = new javax.swing.JComboBox();
		this.jButtonAddOutgoingNode = new javax.swing.JButton();
		this.jScrollPaneOutgoingNode = new javax.swing.JScrollPane();
		this.jListOutgoingNode = new javax.swing.JList();
		this.jLabelParentNode = new javax.swing.JLabel();
		this.jComboBoxParentNode = new javax.swing.JComboBox();
		this.jButtonSave = new javax.swing.JButton();
		this.jTextFieldBehaviour = new javax.swing.JTextField();
		this.jButtonEditBehaviour = new javax.swing.JButton();

		this.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		this.setTitle("Edit Node");

		this.jLabelNodeName.setText("Node Name:");

		this.jLabelNodeBehaviour.setText("Behaviour:");

		this.jLabelIncomingTransition.setText("Incoming transition:");

		this.jLabelSelectIncomingTransition.setText("Select transition:");

		this.jComboBoxIncomingTransition
				.setModel(new javax.swing.DefaultComboBoxModel(new String[] {
						"Item 1", "Item 2", "Item 3", "Item 4" }));

		this.jButtonAddIncomingTransition.setText("Add transition");
		this.jButtonAddIncomingTransition
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(final java.awt.event.ActionEvent evt) {
						EditNode.this.jButtonAddIncomingTransitionActionPerformed(evt);
					}
				});

		this.jScrollPaneIncomingTransition.setViewportView(this.jListIncomingTransition);

		this.jLabelOutgoingNode.setText("Outgoing Node:");

		this.jLabelSelectOutgoingNode.setText("Select Node:");

		this.jComboBoxOutgoingNode.setModel(new javax.swing.DefaultComboBoxModel(
				new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

		this.jButtonAddOutgoingNode.setText("Add Node");
		this.jButtonAddOutgoingNode
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(final java.awt.event.ActionEvent evt) {
						EditNode.this.jButtonAddOutgoingNodeActionPerformed(evt);
					}
				});

		this.jScrollPaneOutgoingNode.setViewportView(this.jListOutgoingNode);

		this.jLabelParentNode.setText("Parent Node:");

		this.jButtonSave.setText("Save");
		this.jButtonSave.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(final java.awt.event.ActionEvent evt) {
				EditNode.this.jButtonSaveActionPerformed(evt);
			}
		});

		this.jButtonEditBehaviour.setText("Edit");
		this.jButtonEditBehaviour
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(final java.awt.event.ActionEvent evt) {
						EditNode.this.jButtonEditBehaviourActionPerformed(evt);
					}
				});

		final org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
				this.getContentPane());
		this.getContentPane().setLayout(layout);
		layout
				.setHorizontalGroup(layout
						.createParallelGroup(
								org.jdesktop.layout.GroupLayout.LEADING)
						.add(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.LEADING)
														.add(
																layout
																		.createParallelGroup(
																				org.jdesktop.layout.GroupLayout.TRAILING)
																		.add(
																				this.jButtonSave)
																		.add(
																				layout
																						.createParallelGroup(
																								org.jdesktop.layout.GroupLayout.LEADING,
																								false)
																						.add(
																								this.jLabelOutgoingNode)
																						.add(
																								layout
																										.createSequentialGroup()
																										.add(
																												this.jLabelSelectOutgoingNode)
																										.addPreferredGap(
																												org.jdesktop.layout.LayoutStyle.UNRELATED)
																										.add(
																												this.jComboBoxOutgoingNode,
																												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																												180,
																												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
																										.addPreferredGap(
																												org.jdesktop.layout.LayoutStyle.UNRELATED)
																										.add(
																												this.jButtonAddOutgoingNode))
																						.add(
																								this.jScrollPaneIncomingTransition)
																						.add(
																								this.jLabelIncomingTransition)
																						.add(
																								layout
																										.createSequentialGroup()
																										.add(
																												this.jLabelSelectIncomingTransition)
																										.addPreferredGap(
																												org.jdesktop.layout.LayoutStyle.UNRELATED)
																										.add(
																												this.jComboBoxIncomingTransition,
																												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																												185,
																												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
																										.addPreferredGap(
																												org.jdesktop.layout.LayoutStyle.UNRELATED)
																										.add(
																												this.jButtonAddIncomingTransition))
																						.add(
																								this.jScrollPaneOutgoingNode)
																						.add(
																								layout
																										.createSequentialGroup()
																										.add(
																												this.jLabelParentNode)
																										.addPreferredGap(
																												org.jdesktop.layout.LayoutStyle.RELATED)
																										.add(
																												this.jComboBoxParentNode,
																												0,
																												org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																												Short.MAX_VALUE))
																						.add(
																								layout
																										.createSequentialGroup()
																										.add(
																												this.jLabelNodeName)
																										.addPreferredGap(
																												org.jdesktop.layout.LayoutStyle.RELATED)
																										.add(
																												this.jTextFieldNodeName,
																												org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																												354,
																												Short.MAX_VALUE))))
														.add(
																org.jdesktop.layout.GroupLayout.TRAILING,
																layout
																		.createSequentialGroup()
																		.add(
																				this.jLabelNodeBehaviour)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED)
																		.add(
																				this.jTextFieldBehaviour,
																				org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																				304,
																				Short.MAX_VALUE)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED)
																		.add(
																				this.jButtonEditBehaviour)))
										.addContainerGap()));
		layout
				.setVerticalGroup(layout
						.createParallelGroup(
								org.jdesktop.layout.GroupLayout.LEADING)
						.add(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(this.jLabelNodeName)
														.add(
																this.jTextFieldNodeName,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
										.add(28, 28, 28)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.LEADING)
														.add(
																layout
																		.createParallelGroup(
																				org.jdesktop.layout.GroupLayout.BASELINE)
																		.add(
																				this.jLabelNodeBehaviour)
																		.add(
																				this.jTextFieldBehaviour,
																				org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																				org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																				org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
														.add(
																this.jButtonEditBehaviour))
										.add(57, 57, 57)
										.add(this.jLabelIncomingTransition)
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(
																this.jLabelSelectIncomingTransition)
														.add(
																this.jComboBoxIncomingTransition,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
														.add(
																this.jButtonAddIncomingTransition))
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												this.jScrollPaneIncomingTransition,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
												77,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
										.add(26, 26, 26)
										.add(this.jLabelOutgoingNode)
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.UNRELATED)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(
																this.jLabelSelectOutgoingNode)
														.add(
																this.jComboBoxOutgoingNode,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
														.add(
																this.jButtonAddOutgoingNode))
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												this.jScrollPaneOutgoingNode,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
												76,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
										.add(27, 27, 27)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(this.jLabelParentNode)
														.add(
																this.jComboBoxParentNode,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED,
												35, Short.MAX_VALUE).add(
												this.jButtonSave).addContainerGap()));

		this.pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jButtonAddOutgoingNodeActionPerformed(
			final java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonAddOutgoingNodeActionPerformed
		final DefaultListModel dm = (DefaultListModel) this.jListOutgoingNode
				.getModel();
		dm.addElement(this.jComboBoxOutgoingNode.getSelectedItem());
	}// GEN-LAST:event_jButtonAddOutgoingNodeActionPerformed

	private void jButtonAddIncomingTransitionActionPerformed(
			final java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonAddIncomingTransitionActionPerformed
		final DefaultListModel dm = (DefaultListModel) this.jListIncomingTransition
				.getModel();
		dm.addElement(this.jComboBoxIncomingTransition.getSelectedItem());

	}// GEN-LAST:event_jButtonAddIncomingTransitionActionPerformed

	private void jButtonSaveActionPerformed(final java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonSaveActionPerformed
		try {
			final String nodeName = this.jTextFieldNodeName.getText();

			if (this.node == null) {
				// this.node = scope.createNode(nodeName, ((Behaviour)
				// this.jComboBoxNodeBehaviour.getSelectedItem()));

				final DefaultListModel dmIncomingTransition = (DefaultListModel) this.jListIncomingTransition
						.getModel();
				for (int i = 0; i < dmIncomingTransition.size(); i++) {
					final String incomingTransitionName = (String) dmIncomingTransition
							.get(i);
					this.scope.linkedNode2Transition(this.node,
							(Transition) this.incomingTransitions.get(
									incomingTransitionName).getFcInterface(
									"service"));
				}

				final DefaultListModel dmOutgoingNode = (DefaultListModel) this.jListOutgoingNode
						.getModel();
				for (int i = 0; i < dmOutgoingNode.size(); i++) {
					final String outgoingNodeName = (String) dmOutgoingNode.get(i);

					final Transition transition = this.scope.createTransition(nodeName
							+ "_to_" + outgoingNodeName, null);
					this.scope.linkedTransition2Node(transition, this.node);

					this.scope.linkedNode2Transition((Node) this.outgoingNode.get(
							outgoingNodeName).getFcInterface("service"),
							transition);
				}
			}
			this.setVisible(false);
			this.e.getTree().refreshAll();
		} catch (final Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}// GEN-LAST:event_jButtonSaveActionPerformed

	private void jButtonEditBehaviourActionPerformed(
			final java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonEditBehaviourActionPerformed
		// TODO add your handling code here:
		Component componentBehaviour = null;
		if ((this.node != null) && (this.node.getBehaviour() != null)) {
			componentBehaviour = this.node.getBehaviour().getComponent();
		}
		this.editBehaviour = new EditBehaviour(this.e, componentBehaviour);
		this.editBehaviour.setVisible(true);
	}// GEN-LAST:event_jButtonEditBehaviourActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButtonAddIncomingTransition;
	private javax.swing.JButton jButtonAddOutgoingNode;
	private javax.swing.JButton jButtonEditBehaviour;
	private javax.swing.JButton jButtonSave;
	private javax.swing.JComboBox jComboBoxIncomingTransition;
	private javax.swing.JComboBox jComboBoxOutgoingNode;
	private javax.swing.JComboBox jComboBoxParentNode;
	private javax.swing.JLabel jLabelIncomingTransition;
	private javax.swing.JLabel jLabelNodeBehaviour;
	private javax.swing.JLabel jLabelNodeName;
	private javax.swing.JLabel jLabelOutgoingNode;
	private javax.swing.JLabel jLabelParentNode;
	private javax.swing.JLabel jLabelSelectIncomingTransition;
	private javax.swing.JLabel jLabelSelectOutgoingNode;
	private javax.swing.JList jListIncomingTransition;
	private javax.swing.JList jListOutgoingNode;
	private javax.swing.JScrollPane jScrollPaneIncomingTransition;
	private javax.swing.JScrollPane jScrollPaneOutgoingNode;
	private javax.swing.JTextField jTextFieldBehaviour;
	private javax.swing.JTextField jTextFieldNodeName;
	// End of variables declaration//GEN-END:variables

}
