/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Event;
import com.ebmwebsourcing.easyviper.core.api.engine.ExecutableElement;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.handler.TerminationHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.fractal.Binding;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.NodeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.TransitionImpl;
import com.ebmwebsourcing.easyviper.tools.InstanceOfUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Cardinality;
import org.objectweb.fractal.fraclet.types.Contingency;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@org.objectweb.fractal.fraclet.annotations.Interface(name="scope", signature=Scope.class)})
@Membrane(controller="composite")
public class ScopeImpl
extends NodeImpl
implements Scope {
    private static final long serialVersionUID = 1L;
    private static int cpt_childsNode = 0;
    private static int cpt_transitions = 0;
    private static Logger log = Logger.getLogger(ScopeImpl.class.getName());
    protected org.objectweb.fractal.api.Component initialNode;
    protected org.objectweb.fractal.api.Component parentExecution;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="childNodes")
    protected Map<String, Node> childNodes = Collections.synchronizedMap(new TreeMap());
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="incomingTransitions")
    protected Map<String, Transition> incomingTransitions = Collections.synchronizedMap(new TreeMap());
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="outgoingTransitions")
    protected Map<String, Transition> outgoingTransitions = Collections.synchronizedMap(new TreeMap());
    @Requires(contingency=Contingency.OPTIONAL, name="behaviour")
    protected Behaviour behaviour;
    @Requires(contingency=Contingency.OPTIONAL, name="parentNode")
    protected Node parentNode;
    @Requires(contingency=Contingency.OPTIONAL, name="execution")
    protected Execution execution;
    protected Map<Fault, Scope> exceptions = new HashMap<Fault, Scope>();
    protected Map<Object, Endpoint> endpoints = new HashMap<Object, Endpoint>();
    protected List<CorrelationGroup> correlationGroups = new ArrayList<CorrelationGroup>();
    protected Exception faultScope = null;
    protected TerminationHandler th = null;
    @Controller
    private org.objectweb.fractal.api.Component component;
    private final Map<QName, Variable> variables = new HashMap<QName, Variable>();

    @Override
    protected void createFc() throws Throwable {
        super.createFc();
        this.create();
    }

    @Override
    protected void listFc(List<String> list) {
        if (this.execution != null) {
            list.add("execution");
        }
        if (this.parentNode != null) {
            list.add("parentNode");
        }
        if (this.behaviour != null) {
            list.add("behaviour");
        }
        list.addAll((Collection<String>)this.outgoingTransitions.keySet());
        list.addAll((Collection<String>)this.incomingTransitions.keySet());
        list.addAll((Collection<String>)this.childNodes.keySet());
        super.listFc(list);
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        super.startFc();
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("execution")) {
            return this.execution;
        }
        if (string.equals("parentNode")) {
            return this.parentNode;
        }
        if (string.equals("behaviour")) {
            return this.behaviour;
        }
        if (string.startsWith("outgoingTransitions")) {
            return this.outgoingTransitions.get(string);
        }
        if (string.startsWith("incomingTransitions")) {
            return this.incomingTransitions.get(string);
        }
        if (string.startsWith("childNodes")) {
            return this.childNodes.get(string);
        }
        return super.lookupFc(string);
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        super.stopFc();
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.equals("execution")) {
            this.execution = (Execution)object;
            return;
        }
        if (string.equals("parentNode")) {
            this.parentNode = (Node)object;
            return;
        }
        if (string.equals("behaviour")) {
            this.behaviour = (Behaviour)object;
            return;
        }
        if (string.startsWith("outgoingTransitions")) {
            this.outgoingTransitions.put(string, (Transition)object);
            return;
        }
        if (string.startsWith("incomingTransitions")) {
            this.incomingTransitions.put(string, (Transition)object);
            return;
        }
        if (string.startsWith("childNodes")) {
            this.childNodes.put(string, (Node)object);
            return;
        }
        super.bindFc(string, object);
    }

    @Override
    protected void destroyFc() throws Throwable {
        super.destroyFc();
        this.destroy();
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("execution")) {
            this.execution = null;
            return;
        }
        if (string.equals("parentNode")) {
            this.parentNode = null;
            return;
        }
        if (string.equals("behaviour")) {
            this.behaviour = null;
            return;
        }
        if (string.startsWith("outgoingTransitions")) {
            this.outgoingTransitions.remove(string);
            return;
        }
        if (string.startsWith("incomingTransitions")) {
            this.incomingTransitions.remove(string);
            return;
        }
        if (string.startsWith("childNodes")) {
            this.childNodes.remove(string);
            return;
        }
        super.unbindFc(string);
    }

    @Override
    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        log.fine("Fractal scope created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        log.fine("Fractal scope initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        log.fine("Fractal scope started: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        log.fine("Fractal scope stopped: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        log.fine("Fractal scope destroyed: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    public void startFractalComponent() throws CoreException {
        FractalHelper.getFractalHelper().startComponent(this.component);
        log.fine("Start the scope: " + this.getName());
    }

    public Node createNode(String string, Behaviour behaviour) throws CoreException {
        log.finest("start create node");
        Node node = null;
        try {
            if (string == null) {
                string = "node_" + this.getAllNodes().size();
            }
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().createNewComponent(NodeImpl.class.getName(), null);
            FractalHelper.getFractalHelper().addComponent(component, this.component, null);
            node = (Node)component.getFcInterface("/content");
            node.init(component);
            node.setName(string);
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                node.setLog(log);
            }
            node = (Node)component.getFcInterface("service");
            org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().createNewComponent(behaviour.getClass().getName(), behaviour.getInitializationContext());
            FractalHelper.getFractalHelper().changeName(component2, String.valueOf(behaviour.getClass().getSimpleName()) + "4" + FractalHelper.getFractalHelper().getName(component));
            FractalHelper.getFractalHelper().addComponent(component2, this.component, null);
            Behaviour behaviour2 = (Behaviour)component2.getFcInterface("/content");
            behaviour2.init(component2);
            behaviour2.setInitializationContext(behaviour.getInitializationContext());
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                behaviour2.setLog(log);
            }
            behaviour2 = (Behaviour)component2.getFcInterface("service");
            this.linkedNodeAndActivity(node, behaviour2);
            log.fine("Creation of the fractal node: " + string);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            log.severe(noSuchInterfaceException.getMessage());
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        log.finest("end of create node");
        return node;
    }

    public Node getInitialNode() throws CoreException {
        Node node = null;
        try {
            if (this.initialNode != null) {
                node = (Node)this.initialNode.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return node;
    }

    public Node getNode(String string) throws CoreException {
        Node node = null;
        try {
            List list = FractalHelper.getFractalHelper().getComponentsByName(this.component, string);
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (list != null) {
                for (org.objectweb.fractal.api.Component component : list) {
                    if (!(component.getFcInterface("service") instanceof Node)) continue;
                    arrayList.add((Node)component.getFcInterface("service"));
                }
            }
            if (arrayList.size() > 1) {
                throw new CoreException("Several node components are the same name");
            }
            if (arrayList.size() > 0) {
                node = (Node)arrayList.get(0);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return node;
    }

    public void deleteExecution(Execution execution) throws CoreException {
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        try {
            arrayList.add(new Binding("service", (Interface)execution.getComponent().getFcInterface("service")));
            FractalHelper.getFractalHelper().deleteBindings(this.getComponent(), arrayList);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException("impossible to delete binding", (Throwable)noSuchInterfaceException);
        }
        FractalHelper.getFractalHelper().deleteComponent(execution.getComponent());
    }

    public void stopAllExecutions() throws CoreException {
        for (Execution execution : this.getParentExecution().getChildExecutions()) {
            execution.stop();
        }
        this.getParentExecution().stop();
    }

    public void end(boolean bl) throws CoreException {
        if (this.th != null) {
            this.th.end((Scope)this);
        }
        if (bl) {
            log.finest("clean all scopes");
            this.cleanScopes(this);
            log.finest("stop all sub components");
            FractalHelper.getFractalHelper().stopAllSubComponents(this.component);
        }
    }

    protected void cleanScopes(Scope scope) throws CoreException {
        Object object2;
        for (Object object2 : scope.getExceptions().values()) {
            this.cleanScopes((Scope)object2);
        }
        scope.setFaultScope(null);
        this.cleanVariables(scope);
        this.cleanBehaviours(scope);
        log.finest("remove all executions");
        if (scope.getParentExecution() != null) {
            scope.getParentExecution().removeChildExecutions();
            object2 = FractalHelper.getFractalHelper().getComponentByInterface(scope.getComponent(), (Interface)scope.getParentExecution(), "service");
            if (object2 != null) {
                FractalHelper.getFractalHelper().deleteComponent((org.objectweb.fractal.api.Component)object2);
            }
        }
        scope.setParentExecution(null);
        try {
            object2 = FractalHelper.getFractalHelper().getComponents(scope.getComponent());
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                org.objectweb.fractal.api.Component component = (org.objectweb.fractal.api.Component)iterator.next();
                if (!FractalHelper.getFractalHelper().isStarted(component)) continue;
                try {
                    Scope scope2 = (Scope)component.getFcInterface("scope");
                    this.cleanScopes(scope2);
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {}
            }
        }
        catch (CoreException coreException) {
            throw new CoreException((Throwable)coreException);
        }
    }

    private void cleanBehaviours(Scope scope) throws CoreException {
        try {
            List list = FractalHelper.getFractalHelper().getComponents(scope.getComponent());
            for (org.objectweb.fractal.api.Component component : list) {
                if (!FractalHelper.getFractalHelper().isStarted(component)) continue;
                try {
                    Behaviour behaviour = (Behaviour)component.getFcInterface("service");
                    behaviour.setState(Behaviour.State.ACTIVITY_ENDED);
                    if (!(behaviour instanceof ReceiverBehaviour)) continue;
                    ((ReceiverBehaviour)behaviour).setMessage(null);
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (CoreException coreException) {
            throw new CoreException((Throwable)coreException);
        }
    }

    private void cleanVariables(Scope scope) throws CoreException {
        log.finest("Clean all variables of scope: " + scope.getName());
        for (Variable variable : scope.getVariables().values()) {
            variable.setValue(null);
        }
    }

    public boolean removeNode(Node node) throws CoreException {
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
            Node node2 = null;
            Map map = FractalHelper.getFractalHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(component);
            Iterator iterator = map.entrySet().iterator();
            Map.Entry entry = null;
            while (iterator != null && iterator.hasNext()) {
                entry = iterator.next();
                if (!((String)entry.getKey()).startsWith("childNodes_")) continue;
                node2 = (Node)entry.getValue();
                this.removeNode(node2);
                map = FractalHelper.getFractalHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(component);
                iterator = map.entrySet().iterator();
            }
            List list = FractalHelper.getFractalHelper().getClientComponentsLinkedToServerInterfacesOfComponent(this.getComponent(), (Interface)component.getFcInterface("service"));
            Iterator iterator2 = list.iterator();
            org.objectweb.fractal.api.Component component2 = null;
            while (iterator2 != null && iterator2.hasNext()) {
                component2 = (org.objectweb.fractal.api.Component)iterator2.next();
                if (!(component2.getFcInterface("service") instanceof Transition)) continue;
                FractalHelper.getFractalHelper().deleteComponent(component2);
                list = FractalHelper.getFractalHelper().getClientComponentsLinkedToServerInterfacesOfComponent(this.getComponent(), (Interface)component.getFcInterface("node"));
                iterator2 = list.iterator();
            }
            FractalHelper.getFractalHelper().deleteComponent(component);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return true;
    }

    public void setInitialNode(Node node) throws CoreException {
        this.initialNode = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
    }

    @Override
    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    @Override
    public void setName(String string) throws CoreException {
        FractalHelper.getFractalHelper().changeName(this.component, string);
    }

    @Override
    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    public Execution getParentExecution() throws CoreException {
        Execution execution = null;
        try {
            if (this.parentExecution != null) {
                execution = (Execution)this.parentExecution.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return execution;
    }

    public List<Transition> getAllTransitions() throws CoreException {
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        List list = FractalHelper.getFractalHelper().getComponents(this.component);
        for (org.objectweb.fractal.api.Component component : list) {
            try {
                if (!(component.getFcInterface("service") instanceof Transition)) continue;
                arrayList.add((Transition)component.getFcInterface("service"));
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {}
        }
        return arrayList;
    }

    public List<Node> getAllNodes() throws CoreException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        List list = FractalHelper.getFractalHelper().getComponents(this.component);
        for (org.objectweb.fractal.api.Component component : list) {
            try {
                if (!(component.getFcInterface("service") instanceof Node)) continue;
                arrayList.add((Node)component.getFcInterface("service"));
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {}
        }
        return arrayList;
    }

    public List<Scope> getAllScopes() throws CoreException {
        ArrayList<Scope> arrayList = new ArrayList<Scope>();
        List list = FractalHelper.getFractalHelper().getComponents(this.component);
        for (org.objectweb.fractal.api.Component component : list) {
            try {
                if (!(component.getFcInterface("scope") instanceof Scope)) continue;
                arrayList.add((Scope)component.getFcInterface("scope"));
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {}
        }
        return arrayList;
    }

    public Transition getTransitionByName(String string) throws CoreException {
        Transition transition = null;
        try {
            List list = FractalHelper.getFractalHelper().getComponentsByName(this.component, string);
            ArrayList<Transition> arrayList = new ArrayList<Transition>();
            if (list != null) {
                for (org.objectweb.fractal.api.Component component : list) {
                    if (!(component.getFcInterface("service") instanceof Transition)) continue;
                    arrayList.add((Transition)component.getFcInterface("service"));
                }
            }
            if (arrayList.size() > 1) {
                throw new CoreException("Several interface components are the same name");
            }
            if (arrayList.size() > 0) {
                transition = (Transition)arrayList.get(0);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return transition;
    }

    public Node getNodeByName(String string) throws CoreException {
        Node node = null;
        try {
            List list = FractalHelper.getFractalHelper().getComponentsByName(this.component, string);
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (list != null) {
                for (org.objectweb.fractal.api.Component component : list) {
                    if (!(component.getFcInterface("service") instanceof Node)) continue;
                    arrayList.add((Node)component.getFcInterface("service"));
                }
            }
            if (arrayList.size() > 1) {
                throw new CoreException("Several node components are the same name");
            }
            if (arrayList.size() > 0) {
                node = (Node)arrayList.get(0);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return node;
    }

    public void linkedTransition2Node(Transition transition, Node node) throws CoreException {
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)transition, "service");
            org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
            if (component == null || component2 == null) {
                throw new CoreException("Impossible to link transition to a node");
            }
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            arrayList.add(new Binding("outgoingTransitions_" + this.formatCounter(cpt_transitions), (Interface)component.getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(component2, arrayList);
            try {
                if (component2.getFcInterface("scope") != null) {
                    Node node2 = (Node)component2.getFcInterface("service");
                    node2.getMapOutgoingTransitions().put("outgoingTransitions_" + this.formatCounter(cpt_transitions), (Transition)component.getFcInterface("service"));
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {}
            arrayList = new ArrayList();
            arrayList.add(new Binding("source", (Interface)component2.getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(component, arrayList);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public void linkedNode2Transition(Node node, Transition transition) throws CoreException {
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
            org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)transition, "service");
            if (component == null || component2 == null) {
                throw new CoreException("Impossible to link node to a transition");
            }
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            arrayList = new ArrayList();
            arrayList.add(new Binding("incomingTransitions_" + this.formatCounter(cpt_transitions), (Interface)component2.getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(component, arrayList);
            try {
                if (component.getFcInterface("scope") != null) {
                    Node node2 = (Node)component.getFcInterface("service");
                    node2.getMapIncomingTransitions().put("incomingTransitions_" + this.formatCounter(cpt_transitions), (Transition)component2.getFcInterface("service"));
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {}
            arrayList = new ArrayList();
            arrayList = new ArrayList();
            arrayList.add(new Binding("destination", (Interface)component.getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(component2, arrayList);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public void linkedNodeAndActivity(Node node, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && node != null) {
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
                org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)behaviour, "service");
                if (component == null || component2 == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> arrayList = new ArrayList<Binding>();
                arrayList.add(new Binding("behaviour", (Interface)component2.getFcInterface("service")));
                FractalHelper.getFractalHelper().addBindings(component, arrayList);
                arrayList = new ArrayList();
                arrayList.add(new Binding("node", (Interface)component.getFcInterface("service")));
                FractalHelper.getFractalHelper().addBindings(component2, arrayList);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            log.finest(noSuchInterfaceException.getMessage());
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public void unlinkedNodeAndActivity(Node node, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && node != null) {
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
                org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)behaviour, "service");
                if (component == null || component2 == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> arrayList = new ArrayList<Binding>();
                arrayList.add(new Binding("behaviour", (Interface)component2.getFcInterface("service")));
                FractalHelper.getFractalHelper().deleteBindings(component, arrayList);
                arrayList = new ArrayList();
                arrayList.add(new Binding("node", (Interface)component.getFcInterface("service")));
                FractalHelper.getFractalHelper().deleteBindings(component2, arrayList);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            log.finest(noSuchInterfaceException.getMessage());
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public void unlinkedNodeAndExecution(Node node, Execution execution) throws CoreException {
        try {
            if (execution != null && node != null) {
                org.objectweb.fractal.api.Component component = null;
                if (node instanceof Scope) {
                    component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "scope");
                } else if (node instanceof Node) {
                    component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
                }
                org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)execution, "service");
                if (component == null || component2 == null) {
                    throw new CoreException("Impossible to unlink node to the execution ");
                }
                ArrayList<Binding> arrayList = new ArrayList<Binding>();
                arrayList.add(new Binding("execution", (Interface)component2.getFcInterface("service")));
                FractalHelper.getFractalHelper().deleteBindings(component, arrayList);
                arrayList = new ArrayList();
                arrayList.add(new Binding("currentTarget", (Interface)component.getFcInterface("service")));
                FractalHelper.getFractalHelper().deleteBindings(component2, arrayList);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            log.finest(noSuchInterfaceException.getMessage());
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public void linked(Node node, Transition transition, Node node2) throws CoreException {
        this.linkedTransition2Node(transition, node);
        this.linkedNode2Transition(node2, transition);
        ++cpt_transitions;
    }

    public void linked(Node node, Node node2) throws CoreException {
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
            org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)node2, "service");
            if (component == null || component2 == null) {
                throw new CoreException("Impossible to link parent and children node");
            }
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            arrayList.add(new Binding("childNodes_" + this.formatCounter(cpt_childsNode), (Interface)component2.getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(component, arrayList);
            ++cpt_childsNode;
            arrayList = new ArrayList();
            arrayList.add(new Binding("parentNode", (Interface)component.getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(component2, arrayList);
            NodeImpl nodeImpl = (NodeImpl)component2.getFcInterface("/content");
            if (nodeImpl.getParentNode() == null) {
                nodeImpl.setParentNode(node);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public void linkedExecution2ExecutableElement(Execution execution, ExecutableElement executableElement) throws CoreException {
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)executableElement, "service");
            org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)execution, "service");
            if (component2 == null || component == null) {
                throw new CoreException("Impossible to link the execution and the target node: exeComp = " + component2 + " or targetComp = " + component);
            }
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            arrayList.add(new Binding("currentTarget", (Interface)component.getFcInterface("service")));
            if (FractalHelper.getFractalHelper().isBinded(component2, "currentTarget")) {
                throw new CoreException("Execution already bind");
            }
            FractalHelper.getFractalHelper().addBindings(component2, arrayList);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public void linkedExecutableElement2Execution(ExecutableElement executableElement, Execution execution) throws CoreException {
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)executableElement, "service");
            org.objectweb.fractal.api.Component component2 = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)execution, "service");
            if (component2 == null || component == null) {
                throw new CoreException("Impossible to link the axecution and the target node");
            }
            if (!FractalHelper.getFractalHelper().isBinded(component, "execution")) {
                ArrayList<Binding> arrayList = new ArrayList<Binding>();
                arrayList = new ArrayList();
                arrayList.add(new Binding("execution", (Interface)component2.getFcInterface("service")));
                FractalHelper.getFractalHelper().addBindings(component, arrayList);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public Transition createTransition(String string, Event event) throws CoreException {
        Transition transition = null;
        org.objectweb.fractal.api.Component component = null;
        try {
            component = FractalHelper.getFractalHelper().createNewComponent(TransitionImpl.class.getName(), null);
            FractalHelper.getFractalHelper().addComponent(component, this.getComponent(), null);
            transition = (Transition)component.getFcInterface("/content");
            ((TransitionImpl)transition).init(component);
            ((TransitionImpl)transition).setName(string);
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                transition.setLog(log);
            }
            transition = (Transition)component.getFcInterface("service");
            log.fine("Creation of the fractal transition: " + string);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return transition;
    }

    public synchronized Execution createExecution(String string) throws CoreException {
        log.finest("start the creation of execution: " + string);
        Execution execution = null;
        org.objectweb.fractal.api.Component component = null;
        try {
            component = FractalHelper.getFractalHelper().createNewComponent(ExecutionImpl.class.getName(), null);
            FractalHelper.getFractalHelper().addComponent(component, this.getComponent(), null);
            FractalHelper.getFractalHelper().changeName(component, string);
            execution = (Execution)component.getFcInterface("/content");
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                execution.setLog(log);
            }
            execution = (Execution)component.getFcInterface("service");
            log.finest("execution created: " + string);
            if (this.getParentExecution() == null) {
                log.finest(String.valueOf(string) + " is a parent execution");
                this.parentExecution = component;
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return execution;
    }

    public Map<QName, Variable> getVariables() {
        return this.variables;
    }

    public Variable findVariable(QName qName) throws CoreException {
        Variable variable = null;
        variable = this.variables.get(qName);
        if (variable == null) {
            Scope scope = this.getParentScope(this);
            while (variable == null && scope != null) {
                variable = (Variable)scope.getVariables().get(qName);
                scope = this.getParentScope(scope);
            }
        }
        return variable;
    }

    public List<CorrelationGroup> findCorrelationGroups(String string) throws CoreException {
        ArrayList<CorrelationGroup> arrayList = new ArrayList<CorrelationGroup>();
        for (CorrelationGroup scope2 : this.correlationGroups) {
            if (scope2.getCorrelations().get(string) == null) continue;
            arrayList.add(scope2);
        }
        Scope scope = this.getParentScope(this);
        if (scope != null) {
            arrayList.addAll(scope.findCorrelationGroups(string));
            Scope scope2 = this.getParentScope(scope);
        }
        return arrayList;
    }

    public Endpoint findEndpoint(Object object) throws CoreException {
        Endpoint endpoint = null;
        endpoint = this.endpoints.get(object);
        if (endpoint == null) {
            Scope scope = this.getParentScope(this);
            while (endpoint == null && scope != null) {
                endpoint = (Endpoint)scope.getEndpoints().get(object);
                scope = this.getParentScope(scope);
            }
        }
        return endpoint;
    }

    public <B extends Behaviour> List<B> findBehaviours(Class<B> clazz) throws CoreException {
        return ScopeImpl.findBehaviours(clazz, this.getComponent(), false);
    }

    public static <B extends Behaviour> List<B> findBehaviours(Class<B> clazz, org.objectweb.fractal.api.Component component, boolean bl) throws CoreException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = FractalHelper.getFractalHelper().getComponents(component);
        for (org.objectweb.fractal.api.Component component2 : list) {
            boolean bl2 = FractalHelper.getFractalHelper().isStarted(component2);
            try {
                Behaviour behaviour = (Behaviour)component2.getFcInterface("service");
                if (InstanceOfUtil.isClassExtendOfClass2found(behaviour.getClass(), clazz)) {
                    if (bl) {
                        arrayList.add(behaviour);
                    } else if (bl2) {
                        arrayList.add(behaviour);
                    }
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
            }
            catch (ClassCastException classCastException) {}
            try {
                if (!(component2.getFcInterface("scope") instanceof Scope)) continue;
                arrayList.addAll(ScopeImpl.findBehaviours(clazz, component2, bl));
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {}
        }
        return arrayList;
    }

    public void setVariable(Variable variable) throws CoreException {
        ScopeImpl scopeImpl = this;
        Variable variable2 = (Variable)scopeImpl.getVariables().get(variable.getQName());
        if (variable2 == null) {
            while (variable2 == null && scopeImpl != null) {
                variable2 = (Variable)scopeImpl.getVariables().get(variable.getQName());
                scopeImpl = this.getParentScope();
            }
        }
        if (scopeImpl != null) {
            scopeImpl.getVariables().put(variable.getQName(), variable);
        } else {
            this.getVariables().put(variable.getQName(), variable);
        }
    }

    public Scope getParentScope() throws CoreException {
        Process process = null;
        try {
            org.objectweb.fractal.api.Component component;
            if (!(this instanceof Process) && (component = FractalHelper.getFractalHelper().getParent(this.getComponent())) != null) {
                try {
                    process = (Process)component.getFcInterface("service");
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    process = (Scope)component.getFcInterface("scope");
                }
                catch (ClassCastException classCastException) {
                    process = (Scope)component.getFcInterface("scope");
                }
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return process;
    }

    private Scope getParentScope(Scope scope) throws CoreException {
        Scope scope2 = null;
        try {
            org.objectweb.fractal.api.Component component;
            if (!(scope instanceof Process) && (component = FractalHelper.getFractalHelper().getParent(scope.getComponent())) != null) {
                scope2 = (Scope)component.getFcInterface("scope");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {}
        return scope2;
    }

    public Process getProcess() throws CoreException {
        Process process = null;
        ScopeImpl scopeImpl = this;
        ScopeImpl scopeImpl2 = this;
        while (scopeImpl != null) {
            if ((scopeImpl = this.getParentScope(scopeImpl)) == null) continue;
            scopeImpl2 = scopeImpl;
        }
        try {
            process = (Process)scopeImpl2.getComponent().getFcInterface("process");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {}
        return process;
    }

    public void linkInitialNodeAndExecution() throws CoreException {
        log.finest("start linkInitialNodeAndExecution");
        try {
            if (this.initialNode != null) {
                if (!FractalHelper.getFractalHelper().isBinded(this.parentExecution, "currentTarget")) {
                    log.finest("bind execution to initial node");
                    ArrayList<Binding> arrayList = new ArrayList<Binding>();
                    arrayList.add(new Binding("currentTarget", (Interface)this.getInitialNode()));
                    FractalHelper.getFractalHelper().addBindings(this.parentExecution, arrayList);
                    log.finest("execution and initial node binded");
                }
                if (!FractalHelper.getFractalHelper().isAlreadyBind(this.initialNode, "execution", (Interface)this.parentExecution)) {
                    this.linkedExecutableElement2Execution((ExecutableElement)this.initialNode.getFcInterface("service"), (Execution)this.parentExecution.getFcInterface("service"));
                    log.finest("initial and execution linked");
                }
            } else {
                log.finest("Initial node not setted");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            log.severe(noSuchInterfaceException.getMessage());
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        log.finest("end of linkInitialNodeAndExecution");
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        log = logger;
    }

    private String formatCounter(int n) {
        String string = "";
        string = n < 10 ? "000" + n : (n < 100 ? "00" + n : (n < 1000 ? "0" + n : String.valueOf(n)));
        return string;
    }

    public Map<Object, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public List<CorrelationGroup> getCorrelationGroups() {
        return this.correlationGroups;
    }

    public Map<Fault, Scope> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(Map<Fault, Scope> map) {
        this.exceptions = map;
    }

    public Exception isFaultScope() {
        return this.faultScope;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(Node node) {
        this.parentNode = node;
    }

    public void setFaultScope(Exception exception) {
        this.faultScope = exception;
    }

    public void setParentExecution(org.objectweb.fractal.api.Component component) {
        this.parentExecution = component;
    }

    public void setTerminationHandler(TerminationHandler terminationHandler) {
        this.th = terminationHandler;
    }

    public TerminationHandler getTerminationHandler() {
        return this.th;
    }
}

