/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink,
 * http://www.petalslink.com/
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.engine.monitoring.Monitor;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.impl.engine.monitoring.MonitorImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=Process.class,names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class ProcessImpl extends ScopeImpl implements Process {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ProcessImpl.class.getName());

	private List<ProcessKey> keys;

	/**
	 * TODO jlesbegu
	 * A process does not have anymore a unique context
	 * for all endpoints but a Map indexing contexts according to
	 * an endpoint and an operation (local part of Interface wsdl definition)  
	 */
	private Map<Endpoint, Map<String,ExternalContext>> externalContexts; 

	private Monitor monitor = new MonitorImpl();

	private State state = State.PROCESS_INACTIVE;

	private Assigner assigner = null;

	public ProcessImpl() throws CoreException {
		super();
		assigner = null;
		externalContexts = new HashMap<Endpoint, Map<String,ExternalContext>>();
	}

	public void run() throws CoreException {
		this.log.finest("run process");
		if((this.state == State.PROCESS_INACTIVE) || (this.state == State.PROCESS_ENDED)){
			this.getMonitor().reset();
			this.getMonitor().setStartTime(Calendar.getInstance().getTime());
		}
		state = State.PROCESS_ACTIVE;
		try {

			this.createParentExecution();

			this.log.finest("start parent execution");
			if (!SCAHelper.getSCAHelper().isStarted(
					this.parentExecution)) {
				SCAHelper.getSCAHelper().startComponent(
						this.parentExecution);
			}
			this.log.finest("parent execution started");

			this.log.finest("run the execution");
			final Execution exec = (Execution) this.parentExecution
			.getFcInterface("service");
			exec.run();

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
		this.log.finest("end of process");
	}

	public void runStepByStep() throws CoreException {
		this.log.finest("run process");
		if((this.state == State.PROCESS_INACTIVE) || (this.state == State.PROCESS_ENDED)){
			this.getMonitor().reset();
			this.getMonitor().setStartTime(Calendar.getInstance().getTime());
		}
		state = State.PROCESS_ACTIVE;
		try {

			this.createParentExecution();

			this.log.finest("start parent execution");
			if (!SCAHelper.getSCAHelper().isStarted(
					this.parentExecution)) {
				SCAHelper.getSCAHelper().startComponent(
						this.parentExecution);
			}
			this.log.finest("parent execution started");

			this.log.finest("run the execution");
			final Execution exec = (Execution) this.parentExecution
			.getFcInterface("service");
			exec.runStepByStep();

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
		this.log.finest("end of process");
	}


	public Execution createParentExecution() throws CoreException {
		Execution res = null;
		try {
			if (this.parentExecution == null) {
				this.log.finest("create parent execution");
				this.parentExecution = SCAHelper
				.getSCAHelper()
				.createNewComponent(ExecutionImpl.class.getName(), null);

				SCAContentController scacc = (SCAContentController)
				this.parentExecution.getFcInterface(SCAContentController.NAME);
				try {
					res = (Execution) scacc.getFcContent();
				}
				catch (ContentInstantiationException e) {
					throw new CoreException(e);
				}
				if (!this.log.getName().equals(ProcessImpl.class.getName())) {
					res.setLog(this.log);
				}

				SCAHelper.getSCAHelper().addComponent(
						this.parentExecution, this.getComponent(), null);
				SCAHelper.getSCAHelper().changeName(
						this.parentExecution, "mainExec");

				if(this.initialNode == null) {
					throw new CoreException("Initial node not setted");
				}
				this.linkInitialNodeAndExecution();
			}

			res = (Execution) this.parentExecution.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}

		return res;
	}

	public Map<String, Execution> getSuspendedExecutions()
	throws CoreException {
		Map<String, Execution> res = new HashMap<String,Execution>();
		try {
			if (this.getParentExecution() != null && this.getParentExecution().getState().equals(Execution.State.SUSPENDED)) {
				res.putAll(getSuspendedExecutions(this.getParentExecution().getParentScope()));
			} else if (this.getParentExecution() == null) {
				final Execution main = this.createParentExecution();
				final Component exec = SCAHelper.getSCAHelper()
				.getComponentByInterface(this.getComponent(),
						(Interface) main, "service");
				SCAHelper.getSCAHelper().startComponent(exec);
				try {
					if(!res.containsKey(this.getParentExecution().getName())) {
						res.put(this.getParentExecution().getName(), this.getParentExecution());
					}
				} catch (CoreException e) {
					// do nothing
				}
			}
		} catch(SCAException e) {
			throw new CoreException(e);
		}
		return res;
	}

	private Map<String, Execution> getSuspendedExecutions(Scope parentScope) {
		Map<String, Execution> res = new HashMap<String, Execution>();
		try {
			log.finest("parentScope "+parentScope.getName());

			if(parentScope != null) {
				List<ReceiverBehaviour> receiveBehaviours = parentScope.findBehaviours(ReceiverBehaviour.class);
				log.finest("Number of receiver behaviours: " + receiveBehaviours.size());


				for(ReceiverBehaviour receiveBehaviour : receiveBehaviours) {
					log.finest("receiver behaviour: " + receiveBehaviour.getName());

					if((receiveBehaviour.getNode().getExecution() != null)&&(receiveBehaviour.getNode().getExecution().getState().equals(Execution.State.SUSPENDED))) {

						if(!res.containsKey(receiveBehaviour.getNode().getExecution().getName())) {
							log.finest("execution \"" + receiveBehaviour.getNode().getExecution().getName() + "\" of receiver behaviour \"" + receiveBehaviour.getName() + "\" is concerned execution." );

							res.put(receiveBehaviour.getNode().getExecution().getName(), receiveBehaviour.getNode().getExecution());

						}
					}

				}
			}
		} catch (CoreException e) {
			// do nothing
			log.severe("Error in getSuspendedExecutions: " + e.getMessage());
		} catch(NullPointerException ne){
			log.severe("Error in getSuspendedExecutions (null pointer): " + ne.getMessage());
		}
		return res;
	}

	public Engine getEngine() throws CoreException {
		Engine res = null;
		try {
			final Component engineComp = SCAHelper.getSCAHelper().getParent(
					this.getComponent());
			res = (Engine) engineComp.getFcInterface("service");
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
		return res;
	}

	@Override
	public com.ebmwebsourcing.easyviper.core.api.engine.Process getProcess()
	throws CoreException {
		return this;
	}

	public Map<Endpoint, Map<String,ExternalContext>> getExternalContexts() {
		return this.externalContexts;
	}


	public ExternalContext getExternalContext(Endpoint serviceendpoint, String operation){
		Map<String, ExternalContext> map = this.externalContexts.get(serviceendpoint);
		if(map != null){
			return map.get(operation);
		}else{
			return null;
		}
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	public Monitor getMonitor() {
		return this.monitor;
	}


	@Override
	public void end(boolean clean) throws CoreException {
		super.end(clean);
		setState(Process.State.PROCESS_ENDED);
		this.log.finest("PROCESS ENDED : " + this.getName());
		this.getMonitor().setEndTime(Calendar.getInstance().getTime());
		for(Map<String, ExternalContext> mapOperationContext : externalContexts.values()){
			for(ExternalContext externalContext : mapOperationContext.values()){
				if(externalContext != null && externalContext.getTerminationHandler() != null) {
					externalContext.getTerminationHandler().end(this);
				}
			}
		}
	}

	public State getState() {
		return this.state;
	}

	public void setState(State state) {
		this.state = state;
	}

	@Override
	public String toString() {
		String res = super.toString();
		if(this.getName() != null) {
			res = this.getName();
		}
		return res;
	}


	public List<ProcessKey> getProcessKeys() {
		return keys;
	}


	public void setProcessKeys(List<ProcessKey> keys) {
		this.keys = keys;
	}


	public Assigner getAssigner() {
		return assigner;
	}

	public void setAssigner(Assigner assigner) {
		this.assigner = assigner;
	}

	@Override
	public void addExternalContext(Endpoint serviceendpoint, String operation,
			ExternalContext context) {

		if(serviceendpoint  != null && serviceendpoint.getServiceName() != null && serviceendpoint.getEndpointName() != null){
			Map<String, ExternalContext> map = this.externalContexts.get(serviceendpoint);
			if(map == null){
				map = new HashMap<String, ExternalContext>();
			}
			map.put(operation, context);
			this.externalContexts.put(serviceendpoint, map);
			log.finest("add external context ... "+this.externalContexts);	
		}

	}



	@Override
	public void removeExternalContext(Endpoint serviceendpoint, String operation) {

		Map<String, ExternalContext> map = this.externalContexts.get(serviceendpoint);

		if(map != null){

			map.remove(operation);

			this.externalContexts.put(serviceendpoint, map);

		}

	}

	@Override
	public void clearExternalContexts() {
		this.externalContexts.clear();

	}

	public Behaviour findBehaviour(String activityName){

		Behaviour behaviour = null;
		try {
			String nodeName = "node_supporting_"+activityName;
			Node n = this.getNodeByName(nodeName);
			if(n != null){
				Component c = SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), nodeName).get(0);
				SCAHelper.getSCAHelper().startComponent(c);
				Component cb = SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), activityName).get(0);
				SCAHelper.getSCAHelper().startComponent(cb);
//				boolean wasstarted = false;
//				if(SCAHelper.getSCAHelper().isStarted(c)){
//					wasstarted = true;
//				}else{
//					SCAHelper.getSCAHelper().startComponent(c);
//				}

				return n.getBehaviour();
			}
		

	} catch (CoreException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}catch (SCAException e) {
		e.printStackTrace();
	}
	//findBehaviour(this.getNodeByName(name), activityName);

	return behaviour;
}

static private Behaviour findBehaviour(Node node, String activityName){
	Behaviour beh = null;

	if((node.getBehaviour() != null) && node.getBehaviour().equals(activityName)){
		return node.getBehaviour();
	}else{
		List<Node> nodes = node.getChildNodes();
		for(Node n : nodes){
			findBehaviour(n, activityName);
		}
	}

	return beh;
}

}
