/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.PolicySets;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.EmptyBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ExitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ForkBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ScopeBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.handler.TerminationHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.tools.InstanceOfUtil;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=Scope.class,names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class ScopeImpl extends NodeImpl implements Scope {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private static int cpt_childsNode = 0;
    private static int cpt_incomingNode = 0;
    private static int cpt_outgoingNode = 0;


    private static Logger log = Logger.getLogger(ScopeImpl.class.getName());

    protected Component initialNode;

    protected Component parentExecution;

    protected Map<Fault, Scope> exceptions = new HashMap<Fault, Scope>();

    protected Map<Object, Endpoint> endpoints = new HashMap<Object, Endpoint>();

    protected List<CorrelationGroup> correlationGroups = new ArrayList<CorrelationGroup>(); 

    protected Exception faultScope = null;

    protected TerminationHandler th = null;


    @SuppressWarnings("unchecked")
    private final Map<QName, Variable> variables = new HashMap<QName, Variable>();

    /**
     * Default Constructor
     * 
     */
    public ScopeImpl() throws CoreException {
        super();
    }


    @SuppressWarnings("unchecked")
    public Node createNode(String behaviourName, final Behaviour behaviourContext)
    throws CoreException {
        ScopeImpl.log.finest("start create node");
        Node node = null;
        String nodeName = null;
        try {

            if (behaviourName == null) {
                behaviourName = getActivityName(behaviourContext);
                nodeName = "node_supporting_"+behaviourName+"_"+ this.getAllNodes().size();
            }else{
                nodeName = "node_supporting_"+behaviourName;
            }

            // create node
            final Component fractalNode = SCAHelper.getSCAHelper()
            .createNewComponent(NodeImpl.class.getName(), null);
            
            SCAHelper.getSCAHelper().addComponent(fractalNode,
                    getComponent(), null);

            SCAContentController scacc = (SCAContentController)
            fractalNode.getFcInterface(SCAContentController.NAME);
            try {
                node = (Node) scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            ((Node) node).setName(nodeName);
            if (!ScopeImpl.log.getName().equals(ScopeImpl.class.getName())) {
                node.setLog(ScopeImpl.log);
            }

            node = (Node) fractalNode.getFcInterface("service");

            // create behaviour
            final Component fractalBehaviour = SCAHelper.getSCAHelper()
            .createNewComponent(behaviourContext.getClass().getName(),
                    (Map)behaviourContext.getInitializationContext());

            SCAHelper.getSCAHelper().changeName(fractalBehaviour, behaviourName);

            SCAHelper.getSCAHelper().addComponent(fractalBehaviour,
                    getComponent(), null);

            Behaviour behaviour = null;
            scacc = (SCAContentController)
            fractalBehaviour.getFcInterface(SCAContentController.NAME);
            try {
                behaviour = (Behaviour) scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            ((Behaviour) behaviour).setInitializationContext(behaviourContext
                    .getInitializationContext());
            if (!ScopeImpl.log.getName().equals(ScopeImpl.class.getName())) {
                behaviour.setLog(ScopeImpl.log);
            }
            behaviour = (Behaviour) fractalBehaviour.getFcInterface("service");

            this.linkedNodeAndFunctionnalBehaviour(node, behaviour);

            ScopeImpl.log.fine("Creation of the fractal node: " + behaviourName);
            

        } catch (final NoSuchInterfaceException e) {
            ScopeImpl.log.severe(e.getMessage());
            throw new CoreException(e);
        } catch (final SCAException e) {
            ScopeImpl.log.severe(e.getMessage());
            throw new CoreException(e);
        }
        ScopeImpl.log.finest("end of create node");
        
        return node;
    }

    private String getActivityName(Behaviour behaviourContext) {
        String res = "unknownactivity";

        if(behaviourContext instanceof AssignBehaviour){
            res = "assign";
        }else if(behaviourContext instanceof EmptyBehaviour){
            res = "empty";
        }else if(behaviourContext instanceof ExitBehaviour){
            res = "exit";
        } else if(behaviourContext instanceof ForkBehaviour){
            res = "flow";
        }else if(behaviourContext instanceof LoopBehaviour){
            res = "loop";
        }else if(behaviourContext instanceof IfBehaviour){
            res = "if";
        }else if(behaviourContext instanceof SenderBehaviour){
            res = "sender";
        }else if(behaviourContext instanceof ReceiverBehaviour){
            res = "receiver";
        }else if(behaviourContext instanceof ScopeBehaviour){
            res = "scope";
        }else if(behaviourContext instanceof WaitBehaviour){
            res = "wait";
        }

        return res;
    }

    public Node getInitialNode() throws CoreException {
        Node res = null;
        try {
            if(this.initialNode != null) {
                res = (Node) this.initialNode.getFcInterface("service");
            }
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return res;
    }

    public Node getNode(final String name) throws CoreException {
        Node res = null;
        try {
            final List<Component> comps = SCAHelper.getSCAHelper()
            .getComponentsByName(getComponent(), name);

            final List<Node> nodes = new ArrayList<Node>();

            if (comps != null) {
                for (final Component comp : comps) {
                    if (comp.getFcInterface("service") instanceof Node) {
                        nodes.add((Node) comp.getFcInterface("service"));
                    }
                }
            }

            if (nodes.size() > 1) {
                throw new CoreException(
                "Several node components are the same name");
            }

            if (nodes.size() > 0) {
                res = nodes.get(0);
            }

        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }

    public void deleteExecution(final Execution exec) throws CoreException {
        // delete binding between scope and execution
        final List<Binding> listOfBindings = new ArrayList<Binding>();
        try {
            listOfBindings.add(new Binding("service",
                    (org.objectweb.fractal.api.Interface) exec.getComponent()
                    .getFcInterface("service")));
            SCAHelper.getSCAHelper().deleteBindings(
                    this.getComponent(), listOfBindings);
            SCAHelper.getSCAHelper().deleteComponent(exec.getComponent());

        } catch (final NoSuchInterfaceException e) {
            throw new CoreException("impossible to delete binding", e);
        } catch (final SCAException e) {
            throw new CoreException("impossible to delete binding", e);
        }

    }

    public void stopAllExecutions() throws CoreException {
        try {
            for (final Execution execution : this.getParentExecution()
                    .getChildExecutions()) {
                ((Execution) execution).stopSCAComponent();
            }
            this.getParentExecution().stopSCAComponent();
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }

    public void end(boolean clean) throws CoreException {
        try {
            // apply termination handler
            if(this.th != null) {
                th.end(this);
            }

            if(clean) {
                ScopeImpl.log.finest("clean all scopes");
                this.cleanScopes(this);

                ScopeImpl.log.finest("stop all sub components");
                SCAHelper.getSCAHelper().stopAllSubComponents(getComponent());
            }
        } catch (final SCAException e) {
            throw new CoreException(e);
        }	
    }

    protected void cleanScopes(Scope scope) throws CoreException {
        for(Scope faultScope: scope.getExceptions().values()) {
            cleanScopes(faultScope);
        }

        //scope.setExceptions(new HashMap<Fault, Scope>());
        scope.setFaultScope(null);

        // clean variables
        cleanVariables(scope);

        // end all behaviours
        cleanBehaviours(scope);

        try {
            // remove all executions
            ScopeImpl.log.finest("remove all executions");
            if (scope.getParentExecution() != null) {
                scope.getParentExecution().removeChildExecutions();
                final Component exeComp = SCAHelper.getSCAHelper()
                .getComponentByInterface(
                        scope.getComponent(),
                        (org.objectweb.fractal.api.Interface) scope
                        .getParentExecution(), "service");
                if (exeComp != null) {
                    SCAHelper.getSCAHelper().deleteComponent(exeComp);
                }
            }
            scope.setParentExecution(null);


            // find under scopes
            List<Component> components = SCAHelper.getSCAHelper().getComponents(scope.getComponent());
            for(Component component: components) {
                if(SCAHelper.getSCAHelper().isStarted(component)) {
                    try {
                        //TODO lesbegu add ... check 
                        if(component.getFcInterface("service") instanceof Scope){
                            Scope underScope = (Scope) component.getFcInterface("service");
                            cleanScopes(underScope);
                        }
                    } catch (NoSuchInterfaceException e) {
                        // do nothing
                    }
                }
            }
        } catch (CoreException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }

    private void cleanBehaviours(Scope scope) throws CoreException {
        // find behaviour
        try {
            List<Component> components = SCAHelper.getSCAHelper().getComponents(scope.getComponent());
            for(Component component: components) {
                if(SCAHelper.getSCAHelper().isStarted(component)) {
                    try {
                        Behaviour behaviour = (Behaviour) component.getFcInterface("service");
                        behaviour.setState(Behaviour.State.ACTIVITY_ENDED);

                        if(behaviour instanceof ReceiverBehaviour) {
                            ((ReceiverBehaviour)behaviour).setMessage(null);
                        }

                    } catch (NoSuchInterfaceException e) {
                        // do nothing
                    } catch (ClassCastException e) {
                        // do nothing
                    }
                }
            }
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }

    @SuppressWarnings("unchecked")
    private void cleanVariables(Scope scope) throws CoreException {
        ScopeImpl.log.finest("Clean all variables of scope: " + scope.getName());
        for(Variable var: scope.getVariables().values()) {
            var.setValue(null);
        }
    }



    public boolean removeNode(final Node node) throws CoreException {
        final boolean res = true;
        try {
            final Component nodeComp = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (org.objectweb.fractal.api.Interface) node,
            "service");

            // delete all child nodes
            Node child = null;
            final String clientItfName = "childNodes_";

            Map<String, org.objectweb.fractal.api.Interface> map = SCAHelper
            .getSCAHelper()
            .getServerInterfacesLinkedToClientInterfacesOfComponent(
                    nodeComp);

            Iterator<Entry<String, org.objectweb.fractal.api.Interface>> entries = map
            .entrySet().iterator();
            Entry<String, org.objectweb.fractal.api.Interface> entry = null;
            while ((entries != null) && (entries.hasNext())) {
                entry = entries.next();
                if (entry.getKey().startsWith(clientItfName)) {
                    child = (Node) entry.getValue();
                    this.removeNode(child);
                    // SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(),
                    // (org.objectweb.fractal.api.Interface) child, "service");

                    map = SCAHelper
                    .getSCAHelper()
                    .getServerInterfacesLinkedToClientInterfacesOfComponent(
                            nodeComp);
                    entries = map.entrySet().iterator();
                }
            }

            // delete the component
            SCAHelper.getSCAHelper().deleteComponent(nodeComp);
        }  catch (final SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }

    public void setInitialNode(final Node initial) throws CoreException {
        try {
            this.initialNode = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (Interface) initial, "service");
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }

    public Execution getParentExecution() throws CoreException {
        Execution res = null;
        try {
            if (this.parentExecution != null) {
                res = (Execution) this.parentExecution
                .getFcInterface("service");
            }
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return res;
    }

    public List<Node> getAllNodes() throws CoreException {
        final List<Node> nodes = new ArrayList<Node>();
        try {
            final List<Component> comps = SCAHelper.getSCAHelper().getComponents(
                    getComponent());
            for (final Component component : comps) {
                try {
                    if (component.getFcInterface("service") instanceof Node) {
                        nodes.add((Node) component.getFcInterface("service"));
                    }
                } catch (final NoSuchInterfaceException e) {
                    // do nothing
                }
            }
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
        return nodes;
    }

    public List<Scope> getAllScopes() throws CoreException {
        final List<Scope> scope = new ArrayList<Scope>();
        try {
            final List<Component> comps = SCAHelper.getSCAHelper().getComponents(
                    getComponent());
            for (final Component component : comps) {
                try {
                    if (component.getFcInterface("service") instanceof Scope) {
                        scope.add((Scope) component.getFcInterface("service"));
                    }
                } catch (final NoSuchInterfaceException e) {
                    // do nothing
                }
            }
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
        return scope;
    }

    public Node getNodeByName(final String name) throws CoreException {
        Node res = null;
        try {
            final List<Component> comps = SCAHelper.getSCAHelper()
            .getComponentsByName(getComponent(), name);

            final List<Node> nodes = new ArrayList<Node>();

            if (comps != null) {
                for (final Component comp : comps) {
                    if (comp.getFcInterface("service") instanceof Node) {
                        nodes.add((Node) comp.getFcInterface("service"));
                    }
                }
            }

            if (nodes.size() > 1) {
                throw new CoreException(
                "Several node components are the same name");
            }

            if (nodes.size() > 0) {
                res = nodes.get(0);
            }

        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }



    public void linkedNodeAndFunctionnalBehaviour(final Node targetNode, final Behaviour behaviour)
    throws CoreException {
        try {
            if ((behaviour != null) && (targetNode != null)) {
                final Component targetComp = SCAHelper
                .getSCAHelper()
                .getComponentByInterface(
                        this.getComponent(),
                        (org.objectweb.fractal.api.Interface) targetNode,
                "service");

                final Component activityComp = SCAHelper
                .getSCAHelper()
                .getComponentByInterface(
                        this.getComponent(),
                        (org.objectweb.fractal.api.Interface) behaviour,
                "service");

                if ((targetComp == null) || (activityComp == null)) {
                    throw new CoreException(
                    "Impossible to link node to a transition");
                }

                // Add binding between target node and behaviour
                List<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour",
                        (org.objectweb.fractal.api.Interface) activityComp
                        .getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(targetComp,
                        listOfBindings);

                // Add binding between behaviour and target node
                listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("node",
                        (org.objectweb.fractal.api.Interface) targetComp
                        .getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(activityComp,
                        listOfBindings);
            }
        } catch (final NoSuchInterfaceException e) {
            log.finest(e.getMessage());
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }




    public void unlinkedNodeAndFunctionnalBehaviour(final Node targetNode, final Behaviour behaviour)
    throws CoreException {
        try {
            if ((behaviour != null) && (targetNode != null)) {
                final Component targetComp = SCAHelper
                .getSCAHelper()
                .getComponentByInterface(
                        this.getComponent(),
                        (org.objectweb.fractal.api.Interface) targetNode,
                "service");

                final Component activityComp = SCAHelper
                .getSCAHelper()
                .getComponentByInterface(
                        this.getComponent(),
                        (org.objectweb.fractal.api.Interface) behaviour,
                "service");

                if ((targetComp == null) || (activityComp == null)) {
                    throw new CoreException(
                    "Impossible to link node to a transition");
                }

                // Add binding between target node and behaviour
                List<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour",
                        (org.objectweb.fractal.api.Interface) activityComp
                        .getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(targetComp,
                        listOfBindings);

                // delete binding between behaviour and target node
                listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("node",
                        (org.objectweb.fractal.api.Interface) targetComp
                        .getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(activityComp,
                        listOfBindings);
            }
        } catch (final NoSuchInterfaceException e) {
            ScopeImpl.log.finest(e.getMessage());
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }





    public void unlinkedNodeAndExecution(final Node targetNode, final Execution execution)
    throws CoreException {
        try {
            if ((execution != null) && (targetNode != null)) {


                Component targetComp = null;

                targetComp = SCAHelper
                .getSCAHelper()
                .getComponentByInterface(
                        this.getComponent(),
                        (org.objectweb.fractal.api.Interface) targetNode,
                "service");

                final Component execComp = SCAHelper
                .getSCAHelper()
                .getComponentByInterface(
                        this.getComponent(),
                        (org.objectweb.fractal.api.Interface) execution,
                "service");

                if ((targetComp == null) || (execComp == null)) {
                    throw new CoreException(
                    "Impossible to unlink node to the execution ");
                }

                // delete binding between target node and execution
                List<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("execution",
                        (org.objectweb.fractal.api.Interface) execComp
                        .getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(targetComp,
                        listOfBindings);

                // delete binding between execution and target node
                listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("currentTarget",
                        (org.objectweb.fractal.api.Interface) targetComp
                        .getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(execComp,
                        listOfBindings);
            }
        } catch (final NoSuchInterfaceException e) {
            ScopeImpl.log.finest(e.getMessage());
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }



    public Node unlinkBrotherNodes(final Node sourceNode, final Node targetNode) throws CoreException{

        Node res = null;
        try {
            
           // System.out.println(SCAHelper.getSCAHelper().getName(((Node)SCAHelper.getSCAHelper().getListOfBindings(sourceNode.getComponent()).get("incomingNodes_0003")).getComponent()));
            Map<String, Object> mapOfBindings = SCAHelper.getSCAHelper().getListOfBindings(sourceNode.getComponent());
            Node afterNode = null;
            String afterName = null;
            for(Entry<String, Object> e : mapOfBindings.entrySet()){
                if(e.getKey().startsWith("outgoingNodes")){

                    afterName = e.getKey();
                    afterNode = (Node)e.getValue();
                    break;
                }
            }

            res = afterNode;

            //TODO This returns every component linked to sourceNode. How to get only the one who is the outgoinnode ?
            List<Component> cs = SCAHelper.getSCAHelper().getClientComponentsLinkedToServerInterfacesOfComponent(this.getComponent(), (Interface) sourceNode.getComponent().getFcInterface("service"));
            List<Boolean> started = new ArrayList<Boolean>();
            for(Component css : cs){
                if(!SCAHelper.getSCAHelper().isStarted(css)){
                    SCAHelper.getSCAHelper().startComponent(css);
                    started.add(Boolean.FALSE);
                }else{
                    started.add(Boolean.TRUE);
                }
            }


            Binding b = new Binding(afterName, (Interface) afterNode.getComponent().getFcInterface("service"));
            List<Binding> bindToDelete = new ArrayList<Binding>();
            bindToDelete.add(b);
            SCAHelper.getSCAHelper().deleteBindings(sourceNode.getComponent(), bindToDelete);

            //TODO This returns every component linked to sourceNode. How to get only the one who is the outgoinnode ?
            int i=0;
            for(Component css : cs){
                if(!started.get(i)){
                    SCAHelper.getSCAHelper().stopComponent(css);
                }
                i++;
            }

        } catch (SCAException e) {
            throw new CoreException(e);
        } catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }

        return res;
    }

    public void linkedBrotherNodes(final Node sourceNode, final Node targetNode)
    throws CoreException {
        try {
            final Component sourceComp = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (org.objectweb.fractal.api.Interface) sourceNode,
            "service");
            final Component targetComp = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (org.objectweb.fractal.api.Interface) targetNode,
            "service");

            if ((sourceComp == null) || (targetComp == null)) {
                throw new CoreException(
                "Impossible to link brother nodes");
            }

            // Add binding between source and target
            List<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("incomingNodes_"
                    + this.formatCounter(ScopeImpl.cpt_incomingNode),
                    (org.objectweb.fractal.api.Interface) sourceComp
                    .getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(targetComp,
                    listOfBindings);
            ScopeImpl.cpt_incomingNode++;

            // Add binding between target and source
            listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("outgoingNodes"
                    + this.formatCounter(ScopeImpl.cpt_outgoingNode),
                    (org.objectweb.fractal.api.Interface) targetComp
                    .getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(sourceComp,
                    listOfBindings);
            ScopeImpl.cpt_outgoingNode++;

        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }

    public void linkedChildNodeToParent(final Node parentNode, final Node childrenNode)
    throws CoreException {
        try {
            final Component parentComp = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (org.objectweb.fractal.api.Interface) parentNode,
            "service");
            final Component childrenComp = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (org.objectweb.fractal.api.Interface) childrenNode,
            "service");

            if ((parentComp == null) || (childrenComp == null)) {
                throw new CoreException(
                "Impossible to link parent and children node");
            }

            // Add binding between parent and child
            List<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("childNodes_"
                    + this.formatCounter(ScopeImpl.cpt_childsNode),
                    (org.objectweb.fractal.api.Interface) childrenComp
                    .getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(parentComp,
                    listOfBindings);
            ScopeImpl.cpt_childsNode++;

            // Add binding between child and parent
            listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("parentNode",
                    (org.objectweb.fractal.api.Interface) parentComp
                    .getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(childrenComp,
                    listOfBindings);



            SCAContentController scacc = (SCAContentController)
            childrenComp.getFcInterface(SCAContentController.NAME);
            NodeImpl nodeContent = null;
            try {
                nodeContent = (NodeImpl) scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            if(nodeContent.getParentNode() == null) {
                nodeContent.setParentNode(parentNode);
            }

        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }

    public void linkedExecution2ExecutableElement(final Execution exe,
            final Node target) throws CoreException {
        try {
            /*
             * This method is invoked with target being either an Interface or
             * a Service reference.
             */
            Component targetComp = null;
            if( target instanceof Interface ) {
                targetComp = SCAHelper.getSCAHelper()
                .getComponentByInterface(this.getComponent(),
                        (org.objectweb.fractal.api.Interface) target,
                "service");
            }
            else {
                targetComp = SCAHelper.getSCAHelper()
                .getComponentByInterface(this.getComponent(),
                        (ServiceReference<?>) target,
                "service");
            }
            Component exeComp = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (org.objectweb.fractal.api.Interface) exe,
            "service");


            if ((exeComp == null) || (targetComp == null)) {
                throw new CoreException(
                        "Impossible to link the execution and the target node: exeComp = " + exeComp + " or targetComp = " + targetComp);
            } 

            // Add binding between execution and target node
            List<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("currentTarget",
                    (org.objectweb.fractal.api.Interface) targetComp
                    .getFcInterface("service")));

            if (SCAHelper.getSCAHelper().isBinded(exeComp,
            "currentTarget")) {
                throw new CoreException("Execution already bind");
            }
            SCAHelper.getSCAHelper().addBindings(exeComp,
                    listOfBindings);
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }

    public void linkedExecutableElement2Execution(final Node source,
            final Execution exe) throws CoreException {
        try {
            final Component sourceComp = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (org.objectweb.fractal.api.Interface) source,
            "service");

            final Component exeComp = SCAHelper.getSCAHelper()
            .getComponentByInterface(this.getComponent(),
                    (org.objectweb.fractal.api.Interface) exe,
            "service");

            if ((exeComp == null) || (sourceComp == null)) {
                throw new CoreException(
                "Impossible to link the axecution and the target node");
            }

            // Add binding between source element and execution
            if (!SCAHelper.getSCAHelper().isBinded(sourceComp,
            "execution")) {
                List<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("execution",
                        (org.objectweb.fractal.api.Interface) exeComp
                        .getFcInterface("service")));

                SCAHelper.getSCAHelper().addBindings(sourceComp,
                        listOfBindings);
            }
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
    }





    /**
     * constructor to feed in subclasses of processes.
     * 
     * @throws CoreException
     */
    public synchronized Execution createExecution(final String execName)
    throws CoreException {
        ScopeImpl.log.finest("start the creation of execution: " + execName);
        Execution execution = null;
        Component fractalExecution = null;

        try {

            fractalExecution = SCAHelper.getSCAHelper()
            .createNewComponent(ExecutionImpl.class.getName(), null);

            SCAHelper.getSCAHelper().addComponent(fractalExecution,
                    this.getComponent(), null);
            SCAHelper.getSCAHelper().changeName(fractalExecution,
                    execName);

            SCAContentController scacc = (SCAContentController)
            fractalExecution.getFcInterface(SCAContentController.NAME);
            try {
                execution = (Execution) scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException(e);
            }
            if (!ScopeImpl.log.getName().equals(ScopeImpl.class.getName())) {
                execution.setLog(ScopeImpl.log);
            }

            execution = (Execution) fractalExecution.getFcInterface("service");


            ScopeImpl.log.finest("execution created: " + execName);

            if (this.getParentExecution() == null) {
                ScopeImpl.log.finest(execName + " is a parent execution");
                this.parentExecution = fractalExecution;
            }

        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }

        return execution;
    }


    @SuppressWarnings("unchecked")
    public Map<QName, Variable> getVariables() {
        return this.variables;
    }

    @SuppressWarnings("unchecked")
    public Variable findVariable(final QName name) throws CoreException {
        Variable v = null;
        v = this.variables.get(name);

        if (v == null) {
            Scope current = this.getParentScope(this);
            while ((v == null) && (current != null)) {
                v = current.getVariables().get(name);
                current = this.getParentScope(current);
            }			
        }

        return v;
    }

    public List<CorrelationGroup> findCorrelationGroups(final String name) throws CoreException {
        List<CorrelationGroup> res = new ArrayList<CorrelationGroup>();

        for(CorrelationGroup correlationGroup: correlationGroups) {
            if(correlationGroup.getCorrelations().get(name) != null) {
                res.add(correlationGroup);
            }
        }

        Scope current = this.getParentScope(this);
        if(current != null) {
            res.addAll(current.findCorrelationGroups(name));
            current = this.getParentScope(current);
        }			

        return res;
    }

    public Endpoint findEndpoint(final Object key) throws CoreException {
        Endpoint ep = null;
        ep = this.endpoints.get(key);

        if (ep == null) {
            Scope current = this.getParentScope(this);
            while ((ep == null) && (current != null)) {
                ep = current.getEndpoints().get(key);
                current = this.getParentScope(current);
            }			
        }

        return ep;
    }

    public Object findEndpointKey(final Endpoint edp){
        Object key = null;

        for(Entry<Object, Endpoint> currentEntry : this.getEndpoints().entrySet()){
            if(currentEntry.getValue().equals(edp)){
                return currentEntry.getKey();
            }
        }

        return key;
    }

    public <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass)
    throws CoreException {
        return findBehaviours(behaviourClass, this.getComponent(), false);
    }

    @SuppressWarnings("unchecked")
    public static <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass, Component comp, boolean ignoreStopComponent)
    throws CoreException {
        List<B> behaviours = new ArrayList<B>();
        try {
            List<Component> components = SCAHelper.getSCAHelper().getAllSubComponents(comp);
            for(Component component: components) {

                boolean isStarted = SCAHelper.getSCAHelper().isStarted(component);
                try {

                    B behaviour = (B) component.getFcInterface("service");

                    if(InstanceOfUtil.isClassExtendOfClass2found(behaviour.getClass(), behaviourClass)) {
                        if(ignoreStopComponent == true) {
                            behaviours.add(behaviour);		
                        } else if(isStarted) {
                            behaviours.add(behaviour);		
                        }
                    }

                } catch (NoSuchInterfaceException e1) {
                    // do nothing
                } catch (ClassCastException e1) {
                    // do nothing
                }

                try {

                    if(component.getFcInterface("service") instanceof Scope) {
                        behaviours.addAll(findBehaviours(behaviourClass, component, ignoreStopComponent));
                    } 

                } catch (NoSuchInterfaceException e) {
                    //do nothing
                }


            }	
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
        return behaviours;
    }







    @SuppressWarnings("unchecked")
    public void setVariable(Variable v) throws CoreException {
        Scope current = this;
        Variable var = current.getVariables().get(v.getQName());
        if (var == null) {
            while ((var == null) && (current != null)) {
                var = current.getVariables().get(v.getQName());
                current = this.getParentScope();
            }
        }



        if (current != null) {
            current.getVariables().put(v.getQName(), v);
        } else {
            this.getVariables().put(v.getQName(), v);
        }
    }

    public Scope getParentScope() throws CoreException {
        Scope parent = null;
        try {
            if (!(this instanceof com.ebmwebsourcing.easyviper.core.api.engine.Process)) {
                final Component parentComp = SCAHelper.getSCAHelper()
                .getParent(this.getComponent());
                if (parentComp != null) {
                    try {
                        parent = (com.ebmwebsourcing.easyviper.core.api.engine.Process) parentComp.getFcInterface("service");
                    } catch (final NoSuchInterfaceException e) {
                        //						parent = (Scope) parentComp.getFcInterface("scope");
                        parent = (Scope) parentComp.getFcInterface("service");
                    } catch (final ClassCastException e) {
                        //						parent = (Scope) parentComp.getFcInterface("scope");
                        parent = (Scope) parentComp.getFcInterface("service");
                    }
                }
            }
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final SCAException e) {
            throw new CoreException(e);
        }
        return parent;
    }

    private Scope getParentScope(Scope child) throws CoreException {
        Scope parent = null;
        try {
            if (!(child instanceof com.ebmwebsourcing.easyviper.core.api.engine.Process)) {
                final Component parentComp = SCAHelper.getSCAHelper()
                .getParent(child.getComponent());
                if (parentComp != null) {
                    parent = (Scope) parentComp.getFcInterface("service");
                }
            }
        } catch (final NoSuchInterfaceException e) {
            // do nothing
        } catch (final SCAException e) {
            // do nothing
        }
        return parent;
    }

    public com.ebmwebsourcing.easyviper.core.api.engine.Process getProcess()
    throws CoreException {
        com.ebmwebsourcing.easyviper.core.api.engine.Process res = null;
        Scope current = this;
        Scope topScope = this;
        while (current != null) {
            current = this.getParentScope(current);
            if (current != null) {
                topScope = current;
            }
        }

        try {
            res = (com.ebmwebsourcing.easyviper.core.api.engine.Process) topScope.getComponent().getFcInterface("service");
        } catch (final NoSuchInterfaceException e) {
            //do nothing
        }

        return res;
    }

    public void linkInitialNodeAndExecution() throws CoreException {
        ScopeImpl.log.finest("start linkInitialNodeAndExecution");
        try {
            if (this.initialNode != null) {
                // Add binding between execution and initial node
                if (!SCAHelper.getSCAHelper().isBinded(
                        this.parentExecution, "currentTarget")) {

                    ScopeImpl.log.finest("bind execution to initial node");
                    final List<Binding> listOfBindings = new ArrayList<Binding>();
                    listOfBindings.add(new Binding("currentTarget",
                            (org.objectweb.fractal.api.Interface) this
                            .getInitialNode()));
                    SCAHelper.getSCAHelper().addBindings(
                            this.parentExecution, listOfBindings);
                    ScopeImpl.log.finest("execution and initial node binded");

                }

                // link the initial node to the execution
                if (!SCAHelper
                        .getSCAHelper()
                        .isAlreadyBind(
                                this.initialNode,
                                "execution",
                                (org.objectweb.fractal.api.Interface) this.parentExecution)) {
                    this.linkedExecutableElement2Execution(
                            (Node) this.initialNode
                            .getFcInterface("service"),
                            (Execution) this.parentExecution
                            .getFcInterface("service"));
                    ScopeImpl.log.finest("initial and execution linked");
                }
            } else {
                log.finest("Initial node not setted");
            }
        } catch (final NoSuchInterfaceException e) {
            ScopeImpl.log.severe(e.getMessage());
            throw new CoreException(e);
        } catch (final SCAException e) {
            ScopeImpl.log.severe(e.getMessage());
            throw new CoreException(e);
        }
        ScopeImpl.log.finest("end of linkInitialNodeAndExecution");
    }

    @Override
    public void setLog(final Logger logger) {
        super.setLog(logger);
        ScopeImpl.log = logger;
    }

    private String formatCounter(int cpt) {
        String res = "";
        if(cpt < 10) {
            res = "000" + cpt;
        } else if(cpt < 100) {
            res = "00" + cpt;
        } else if(cpt < 1000) {
            res = "0" + cpt;
        } else {
            res = String.valueOf(cpt);
        }
        return res;
    }

    public Map<Object, Endpoint> getEndpoints() {
        return endpoints;
    }

    public List<CorrelationGroup> getCorrelationGroups() {
        return correlationGroups;
    }

    public Map<Fault, Scope> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(Map<Fault, Scope> exceptions) {
        this.exceptions = exceptions;
    }

    public Exception isFaultScope() {
        return this.faultScope;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public void setFaultScope(Exception faultScope) {
        this.faultScope = faultScope;
    }

    public void setParentExecution(Component parentExecution) {
        this.parentExecution = parentExecution;
    }

    public void setTerminationHandler(TerminationHandler th) {
        this.th = th;
    }

    public TerminationHandler getTerminationHandler() {
        return this.th;
    }










}
