/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.Map;
import java.util.logging.Logger;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.EmptyBehaviour;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=EmptyBehaviour.class,names="service")
public class EmptyBehaviourImpl extends AbstractBehaviourImpl implements EmptyBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(EmptyBehaviourImpl.class.getName());


	public EmptyBehaviourImpl() {
	}

	public Map<String, Object> getInitializationContext()
			throws SCAException {
		return null;
	}

	public void setInitializationContext(final Map<String, Object> context)
			throws SCAException {
		// do nothing
	}

	@Override
	public String toString() {
		return "EmptyActivity";
	}


	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	@Override
	protected void executeOnEnded() throws CoreException {
		
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		this.log.finest("start empty behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;
		this.log.finest("execute empty behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_ENDED;
	}

	@Override
	protected void executeOnStarted() throws CoreException {
	
	}
}