/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=LoopBehaviour.class,names="service")
public class LoopBehaviourImpl extends AbstractBehaviourImpl implements LoopBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(LoopBehaviourImpl.class.getName());

	private ConditionalExpression condition;

	private boolean applyConditionAtBegin = true;

	public Map<String, Object> getInitializationContext()
	throws SCAException {
		final Map<String, Object> context = new HashMap<String, Object>();
		context.put("condition", this.condition);
		context.put("applyConditionAtBegin", this.applyConditionAtBegin);
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
	throws SCAException {
		this.condition = (ConditionalExpression) context.get("condition");
		this.applyConditionAtBegin = (Boolean) context.get("applyConditionAtBegin");
	}

	private void whileExecution() throws CoreException {
		Boolean cond = (Boolean) this.condition.evaluate(this.getNode().getExecution()
				.getParentScope());
		if (cond != null && cond == true) {
			final List<Node> childs = this.node.getChildNodes();
			if ((childs != null) && (childs.size() > 0)) {
				getNode().getExecution().setNextExecutableElements(this, childs.get(0));
			}
		} else {
			this.log.finest("end while behaviour on node: " + this.node.getName());
			this.state = State.ACTIVITY_ENDED;
		}
	}

	
	private void repeatUntilExecution(boolean first) throws CoreException {

		boolean ok = true;
		if(!first) {
			Boolean cond = (Boolean) this.condition.evaluate(this.getNode().getExecution().getParentScope());
			if (cond == null || cond == false) {
				this.log.finest("end repeat until behaviour on node: " + this.node.getName());
				this.state = State.ACTIVITY_ENDED;
				ok = false;
			} 
		}
		if(ok) {
			final List<Node> childs = this.node.getChildNodes();
			if ((childs != null) && (childs.size() > 0)) {
				getNode().getExecution().setNextExecutableElements(this, childs.get(0));
			}
		}
	}

	@Override
	public String toString() {
		return "Sequence";
	}

	public ConditionalExpression getCondition() {
		return this.condition;
	}

	public void setCondition(final ConditionalExpression expression) {
		this.condition = expression;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	public boolean getApplyConditionAtBegin() {
		return this.applyConditionAtBegin;
	}

	public void setApplyConditionAtBegin(boolean apply) {
		this.applyConditionAtBegin = apply;
	}

	@Override
	protected void executeOnEnded() throws CoreException {
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		this.state = State.ACTIVITY_STARTED;
		if(this.applyConditionAtBegin == true) {
			this.log.finest("start while behaviour on node: " + this.node.getName());				
			this.whileExecution();
		} else {
			this.log.finest("start repeat until behaviour on node: " + this.node.getName());
			this.repeatUntilExecution(true);
		}
	}

	@Override
	protected void executeOnStarted() throws CoreException {
		if(this.applyConditionAtBegin == true) {
			this.whileExecution();
		} else {
			this.repeatUntilExecution(false);
		}
	}
}
