/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReThrowBehaviour;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ReThrowBehaviour.class,names="service")
public class ReThrowBehaviourImpl extends AbstractBehaviourImpl implements ReThrowBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ReThrowBehaviourImpl.class.getName());

	public ReThrowBehaviourImpl() {
	}

	public Map<String, Object> getInitializationContext()
	throws SCAException {
		final Map<String, Object> context = new HashMap<String, Object>();
		return context;
	}

	public void setInitializationContext(final Map<String, Object> context)
	throws SCAException {
	}

	@Override
	public String toString() {
		return "ThrowActivity";
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	@Override
	protected void executeOnEnded() throws CoreException {
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		this.log.finest("start rethrow behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;

		// find exception
		Exception e = null;
		Scope currentScope =  this.getNode().getExecution().getParentScope();
		while(e==null && currentScope != null) {
			e = currentScope.isFaultScope();
			currentScope = currentScope.getParentScope();
		}

		if(e == null) {
			throw new CoreException("Impossible to find exception to rethrow");
		}

		this.log.finest("execute rethrow behaviour: " + e.getClass());
		if(!(e instanceof CoreException)) {
			throw new CoreException(e);
		} else {
			throw (CoreException)e;
		}
	}

	@Override
	protected void executeOnStarted() throws CoreException {
	}

}