/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.pattern;

import java.util.Iterator;

import org.oasisopen.sca.ServiceReference;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SequenceBehaviourImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ReorganizationPatternFactory {

    private static ReorganizationPatternFactory instance;

    private ReorganizationPatternFactory() {

    }

    public static ReorganizationPatternFactory getInstance() {
        if (ReorganizationPatternFactory.instance == null) {
            ReorganizationPatternFactory.instance = new ReorganizationPatternFactory();
        }
        return ReorganizationPatternFactory.instance;
    }

    public Node convertFork2Sequence(Node forkNode, Scope parent) throws CoreException {
        try {
            if ((forkNode == null)||(parent == null)) {
                throw new CoreException("sequence node or scope cannot be null");
            }

            Component forkComp = SCAHelper.getSCAHelper().getComponentByInterface(parent.getComponent(), (Interface) forkNode, "service");  
            if(!SCAHelper.getSCAHelper().isStarted(forkComp)) {
                SCAHelper.getSCAHelper().startComponent(forkComp);
            }

            // unlink old behaviour
            Behaviour sequenceBehaviouur = forkNode.getBehaviour();
            parent.unlinkedNodeAndFunctionnalBehaviour(forkNode, sequenceBehaviouur);

            // delete old behaviour
            Component behaviourComp = SCAHelper.getSCAHelper().getComponentByInterface(parent.getComponent(), (Interface) sequenceBehaviouur, "service");
            SCAHelper.getSCAHelper().deleteComponent(behaviourComp);

            // change node name
            forkNode.setName(forkNode.getName().toLowerCase().replace("fork", "sequence"));

            // create new behaviour
            Behaviour sequenceBehaviour = new SequenceBehaviourImpl();
            final Component fractalActivity = SCAHelper.getSCAHelper()
            .createNewComponent(sequenceBehaviour.getClass().getName(),
                    null);
            SCAHelper.getSCAHelper().changeName(
                    fractalActivity,
                    sequenceBehaviour.getClass().getSimpleName()
                    + "4"
                    + SCAHelper.getSCAHelper().getName(
                            forkComp));
            SCAHelper.getSCAHelper().addComponent(fractalActivity,
                    parent.getComponent(), null);
            //			sequenceBehaviour = (FunctionnalBehaviour) fractalActivity
            //			.getFcInterface("/content");
            SCAContentController scacc = (SCAContentController)
            fractalActivity.getFcInterface(SCAContentController.NAME);
            try {
                sequenceBehaviour = (Behaviour) scacc.getFcContent();
            }
            catch( ContentInstantiationException cie ) {
                throw new CoreException(cie);
            }

            ((Behaviour) sequenceBehaviour).setInitializationContext(sequenceBehaviour
                    .getInitializationContext());
            if (!parent.getLogger().getName().equals(ScopeImpl.class.getName())) {
                sequenceBehaviour.setLog(parent.getLogger());
            }
            sequenceBehaviour = (Behaviour) fractalActivity.getFcInterface("service");

            // link new behaviour
            parent.linkedNodeAndFunctionnalBehaviour(forkNode, sequenceBehaviour);

            // add transitions between all child node
            Iterator<Node> it = forkNode.getChildNodes().iterator();
            
            
            
            SCAHelper.getSCAHelper().startComponentAndSubComponents(parent.getComponent());
            Node node1 = null;
            //Component node1Comp = null;
            Node node2 = null;
            Component node2Comp = null;
            int i = 1;
            while(it.hasNext()) {
                node1 = it.next();

                
                Component fractalNode = node1.getComponent();
                Node node11 = (Node) fractalNode.getFcInterface("service");
                node1 = node11;
                //node1Comp = SCAHelper.getSCAHelper().getComponentByInterface(parent.getComponent(), (ServiceReference<?>) node1, "service");
                //SCAContentController sc1 = (SCAContentController)node1Comp.getFcInterface(SCAContentController.NAME);
                //node1 = (Node)sc1.getFcContent();
                if(it.hasNext()) {
                    node2 = it.next();
                    Component fractalNode2 = node2.getComponent();
                    Node node22 = (Node) fractalNode2.getFcInterface("service");
                    node2 = node22;
                    //					node2Comp = SCAHelper.getSCAHelper().getComponentByInterface(parent.getComponent(), (ServiceReference<?>) node2, "service");
                    //					SCAContentController sc = (SCAContentController)node2Comp.getFcInterface(SCAContentController.NAME);
                    //					node2 = (Node)sc.getFcContent();
                }

                if((node1 != null)&&(node2 != null)) {
                    parent.linkedBrotherNodes(node1, node2);
                    i++;
                }

                node1 = null;
                node2 = null;
            }


        } catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (SCAException e) {
            throw new CoreException(e);
        } 

        return forkNode;
    }


}
