/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.impl.marshalling.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.marshalling.factory.VariableFactory;
import com.ebmwebsourcing.easyviper.core.impl.marshalling.ViperJAXBContext;
import com.ebmwebsourcing.easyviper.model.ObjectFactory;
import com.ebmwebsourcing.easyviper.model.Tvariable;

public class VariableFactoryImpl implements VariableFactory {

	private Class<? extends Variable<?>> variableClass;
	
	private ObjectFactory factory = null;
	

	public VariableFactoryImpl(Class<? extends Variable<?>> varClass){
		this.variableClass = varClass;
	}


	public Variable<?> read(Document doc) throws CoreException {

		Variable<?> res = null;

		JAXBElement<Tvariable> tvar;

		try {
			tvar = ViperJAXBContext.getInstance().getJaxbContext().createUnmarshaller().unmarshal(doc, Tvariable.class);

			Constructor constructor = (Constructor) this.variableClass.getConstructor(Tvariable.class, AbstractSchemaElementImpl.class);

			if(constructor == null){
				throw new CoreException("Constructor can not be null!");
			}

				res = ((Variable<?>)constructor.newInstance(tvar.getValue(), null));
			

		} catch (JAXBException e) {
			throw new CoreException(e.getMessage());
		} catch (IllegalArgumentException e) {
			throw new CoreException(e.getMessage());
		} catch (SecurityException e) {
			throw new CoreException(e.getMessage());
		} catch (InstantiationException e) {
			throw new CoreException(e.getMessage());
		} catch (IllegalAccessException e) {
			throw new CoreException(e.getMessage());
		} catch (InvocationTargetException e) {
			throw new CoreException(e.getMessage());
		} catch (NoSuchMethodException e) {
			throw new CoreException(e.getMessage());
		}	
		return res;
	}


	public Document getDocument(Variable<?> v) throws CoreException {


		DocumentBuilder builder;
		Document res = null;
		try {
			builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			res = builder.newDocument();

		
			
			this.factory = (ObjectFactory) ViperJAXBContext.getObjectFactory(ViperJAXBContext.getDefaultObjectFactories().get(0));
			
			JAXBElement<Tvariable> jaxbVar = this.factory.createVariable((Tvariable) ((AbstractSchemaElementImpl)v).getModel()); 

			ViperJAXBContext.getInstance().getJaxbContext().createMarshaller().marshal(jaxbVar, res);

		

		}catch (JAXBException e) {
			throw new CoreException(e.getMessage());
		}catch(ParserConfigurationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		return res;
	}





	public Variable<?> create() throws CoreException {

		Tvariable tvar = new Tvariable();

		Variable<?> res =  null;
		try {

			res = ((Variable<?>)this.variableClass.getConstructors()[0].newInstance(tvar, null));
		} catch (IllegalArgumentException e) {
			throw new CoreException(e.getMessage());
		} catch (SecurityException e) {
			throw new CoreException(e.getMessage());
		} catch (InstantiationException e) {
			throw new CoreException(e.getMessage());
		} catch (IllegalAccessException e) {
			throw new CoreException(e.getMessage());
		} catch (InvocationTargetException e) {
			throw new CoreException(e.getMessage());
		}

		return res;
	}



}
