/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.marshalling;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.marshalling.factory.InternalMessageFactoryImpl;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import junit.framework.Assert;
import org.junit.Test;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ViperInternalMessageMarshallingTest {
    private Logger log = Logger.getLogger(this.getClass().getSimpleName());
    private static final String ns = "http://easyviper/test";

    private InternalMessage<Element> createInternalMessage() throws CoreException, ParserConfigurationException {
        InternalMessage internalMessage = null;
        InternalMessageFactoryImpl internalMessageFactoryImpl = new InternalMessageFactoryImpl();
        internalMessage = (InternalMessage)internalMessageFactoryImpl.create();
        QName qName = new QName(ns, "myVar");
        internalMessage.setQName(qName);
        internalMessage.setEndpoint("myEndpoint");
        internalMessage.setOperationName("myOperation");
        internalMessage.setService(new QName(ns, "myService"));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element element = document.createElementNS("urn:namespaceMessageContent", "content");
        document.appendChild(element);
        Element element2 = document.createElementNS("urn:namespaceMessageContent", "root");
        element.appendChild(element2);
        Element element3 = document.createElementNS("urn:namespaceMessageContent", "node1");
        element3.setTextContent("node1 text content");
        element2.appendChild(element3);
        internalMessage.setContent((Object)document.getDocumentElement());
        return internalMessage;
    }

    @Test
    public void testCreateMarshalling() {
        this.log.finest("Creation test ...");
        try {
            InternalMessage<Element> internalMessage = this.createInternalMessage();
            Assert.assertEquals((Object)new QName(ns, "myVar"), (Object)internalMessage.getQName());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            Assert.fail((String)("=>testCreate: \n" + coreException.getMessage()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            Assert.fail((String)("=>testCreate: \n" + parserConfigurationException.getMessage()));
        }
    }

    @Test
    public void testWriteMarshalling() {
        try {
            InternalMessage<Element> internalMessage = this.createInternalMessage();
            this.log.finest("write test");
            InternalMessageFactoryImpl internalMessageFactoryImpl = new InternalMessageFactoryImpl();
            Document document = internalMessageFactoryImpl.getDocument(internalMessage);
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ns2:internalmessage xmlns:ns2=\"http://ebmwebsourcing.com/easyviper/model/light\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <ns2:qname xmlns=\"http://easyviper/test\">myVar</ns2:qname>\n  <ns2:endpoint>myEndpoint</ns2:endpoint>\n  <ns2:service xmlns=\"http://easyviper/test\">myService</ns2:service>\n  <ns2:operation>myOperation</ns2:operation>\n  <ns2:content>\n    <root:root xmlns:root=\"urn:namespaceMessageContent\" xmlns=\"urn:namespaceMessageContent\">\n      <node1>node1 text content</node1>\n    </root:root>\n  </ns2:content>\n</ns2:internalmessage>";
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)string, (String)XMLPrettyPrinter.prettyPrint((Document)document)));
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            Assert.fail((String)("==testWrite\n" + coreException.getMessage()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            Assert.fail((String)("==testWrite\n" + parserConfigurationException.getMessage()));
        }
    }

    @Test
    public void testReadMarshalling() {
        try {
            InternalMessageFactoryImpl internalMessageFactoryImpl = new InternalMessageFactoryImpl();
            InternalMessage<Element> internalMessage = this.createInternalMessage();
            Document document = internalMessageFactoryImpl.getDocument(internalMessage);
            System.out.println("messageExpectedAsDoc: \n" + XMLPrettyPrinter.prettyPrint((Document)document));
            InternalMessage internalMessage2 = (InternalMessage)internalMessageFactoryImpl.read(document);
            Document document2 = internalMessageFactoryImpl.getDocument((Object)internalMessage2);
            System.out.println("messageAsDoc: \n" + XMLPrettyPrinter.prettyPrint((Document)document2));
            Assert.assertEquals((String)internalMessage2.getEndpoint(), (String)internalMessage.getEndpoint());
            Assert.assertEquals((String)internalMessage2.getOperationName(), (String)internalMessage.getOperationName());
            Assert.assertEquals((Object)internalMessage2.getQName(), (Object)internalMessage.getQName());
            Assert.assertEquals((Object)internalMessage2.getService(), (Object)internalMessage.getService());
            DOMSource dOMSource = new DOMSource(document2);
            InputSource inputSource = SourceHelper.convertDOMSource2InputSource((DOMSource)dOMSource);
            InputStream inputStream = inputSource.getByteStream();
            DOMSource dOMSource2 = new DOMSource(document);
            InputSource inputSource2 = SourceHelper.convertDOMSource2InputSource((DOMSource)dOMSource2);
            InputStream inputStream2 = inputSource2.getByteStream();
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((InputStream)inputStream, (InputStream)inputStream2));
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            Assert.fail((String)("==testRead\n" + coreException.getMessage()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            Assert.fail((String)("==testRead\n" + parserConfigurationException.getMessage()));
        }
        catch (XmlException xmlException) {
            xmlException.printStackTrace();
            Assert.fail((String)("==testRead\n" + xmlException.getMessage()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("==testRead\n" + exception.getMessage()));
        }
    }
}

