/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.marshalling;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.marshalling.factory.InternalMessageFactoryImpl;
import com.ebmwebsourcing.easyviper.core.impl.marshalling.factory.VariableFactoryImpl;
import com.ebmwebsourcing.easyviper.core.impl.test.util.StringVariableImpl;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ViperVariableMarshallingTest {
    private Logger log = Logger.getLogger(this.getClass().getSimpleName());
    private static final String ns = "http://easyviper/test";

    private Variable createVariable() throws CoreException {
        Variable variable = null;
        VariableFactoryImpl variableFactoryImpl = new VariableFactoryImpl(StringVariableImpl.class);
        variable = (Variable)variableFactoryImpl.create();
        QName qName = new QName(ns, "myVar");
        variable.setQName(qName);
        return variable;
    }

    private InternalMessage<Element> createInternalMessage() throws CoreException, ParserConfigurationException {
        InternalMessage internalMessage = null;
        InternalMessageFactoryImpl internalMessageFactoryImpl = new InternalMessageFactoryImpl();
        internalMessage = (InternalMessage)internalMessageFactoryImpl.create();
        QName qName = new QName(ns, "myVar");
        internalMessage.setQName(qName);
        internalMessage.setEndpoint("myEndpoint");
        internalMessage.setOperationName("myOperation");
        internalMessage.setService(new QName(ns, "myService"));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element element = document.createElementNS("urn:namespaceMessageContent", "content");
        document.appendChild(element);
        Element element2 = document.createElementNS("urn:namespaceMessageContent", "root");
        element.appendChild(element2);
        Element element3 = document.createElementNS("urn:namespaceMessageContent", "node1");
        element3.setTextContent("node1 text content");
        element2.appendChild(element3);
        internalMessage.setContent((Object)document.getDocumentElement());
        return internalMessage;
    }

    @Test
    public void testCreateMarshalling() {
        this.log.finest("Creation test ...");
        Variable variable = null;
        try {
            variable = this.createVariable();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            junit.framework.Assert.fail();
        }
        junit.framework.Assert.assertEquals((Object)new QName(ns, "myVar"), (Object)variable.getQName());
    }

    @Test
    public void testWriteMarshalling() {
        Document document = null;
        try {
            this.log.finest("write test");
            Variable variable = this.createVariable();
            VariableFactoryImpl variableFactoryImpl = new VariableFactoryImpl(StringVariableImpl.class);
            document = variableFactoryImpl.getDocument((Object)variable);
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ns2:variable xmlns:ns2=\"http://ebmwebsourcing.com/easyviper/model/light\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <ns2:name xmlns=\"http://easyviper/test\">myVar</ns2:name>\n</ns2:variable>";
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)string, (String)XMLPrettyPrinter.prettyPrint((Document)document)));
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            junit.framework.Assert.fail();
        }
    }

    @Test
    public void testReadMarshalling() {
        VariableFactoryImpl variableFactoryImpl = new VariableFactoryImpl(StringVariableImpl.class);
        Variable variable = null;
        Document document = null;
        try {
            variable = this.createVariable();
            document = variableFactoryImpl.getDocument((Object)variable);
            Variable variable2 = (Variable)variableFactoryImpl.read(document);
            if (variable == null) {
                junit.framework.Assert.fail((String)"var is null");
            }
            if (variable2 == null) {
                junit.framework.Assert.fail((String)"varRes is null");
            }
            junit.framework.Assert.assertEquals((Object)variable, (Object)variable2);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            junit.framework.Assert.fail();
        }
    }

    @Test
    public void testReadWithContent() {
        VariableFactoryImpl variableFactoryImpl = new VariableFactoryImpl(StringVariableImpl.class);
        Variable variable = null;
        Document document = null;
        try {
            variable = this.createVariable();
            InternalMessage<Element> internalMessage = this.createInternalMessage();
            variable.setValue(internalMessage);
            document = variableFactoryImpl.getDocument((Object)variable);
            System.out.println(XMLPrettyPrinter.prettyPrint((Document)document));
            Variable variable2 = (Variable)variableFactoryImpl.read(document);
            if (variable == null) {
                junit.framework.Assert.fail((String)"var is null");
            }
            if (variable2 == null) {
                junit.framework.Assert.fail((String)"varRes is null");
            }
            if (variable.getValue() == null) {
                junit.framework.Assert.fail((String)"var.getValue is null");
            }
            if (variable2.getValue() == null) {
                junit.framework.Assert.fail((String)"varRes.getValue is null");
            }
            junit.framework.Assert.assertEquals((String)variable.getQName().toString(), (String)variable2.getQName().toString());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            junit.framework.Assert.fail();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            junit.framework.Assert.fail();
        }
    }
}

