/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ForkPatternTest {
    @Test
    public void testForkWithoutChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        Node node = CreationPatternFactory.getInstance().createForkPattern("fork", null, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testForkWithOneChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createForkPattern("fork", arrayList, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Ignore(value="Unpredictable test... FIXME")
    public void testForkWithTwoChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, IOException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createForkPattern("fork", arrayList, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Execution execution2 = (Execution)execution.getChildExecutions().get(0);
        Execution execution3 = (Execution)execution.getChildExecutions().get(1);
        Assert.assertEquals((String)"node_supporting_first", (String)execution2.getCurrentTarget().getName());
        Assert.assertEquals((String)"node_supporting_second", (String)execution3.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution2.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution3.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution2.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution2.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution.signal();
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution3.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution3.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
    }

    @Test
    @Ignore(value="Unpredictable test... FIXME")
    public void testForkWithTwoChildPatternDifferentSteppingOrder() throws CoreException, NoSuchInterfaceException, InterruptedException, IOException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createForkPattern("fork", arrayList, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Execution execution2 = (Execution)execution.getChildExecutions().get(0);
        Execution execution3 = (Execution)execution.getChildExecutions().get(1);
        Assert.assertEquals((String)"node_supporting_first", (String)execution2.getCurrentTarget().getName());
        Assert.assertEquals((String)"node_supporting_second", (String)execution3.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution2.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution3.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution2.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution2.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution3.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution3.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution.signal();
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
    }

    @Test
    public void testForkWithTwoChildAndAroundNodePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        Node node = process.createNode("start", (Behaviour)new EmptyBehaviourImpl());
        Node node2 = CreationPatternFactory.getInstance().createForkPattern("fork", arrayList, (Scope)process);
        Node node3 = process.createNode("end", (Behaviour)new EmptyBehaviourImpl());
        process.linkedBrotherNodes(node, node2);
        process.linkedBrotherNodes(node2, node3);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testForkWithUnderForkAndWithTwoChildAndAroundNodePatternStepByStep() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("childfirst_1", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("childfirst_2", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createForkPattern("firstfork", arrayList, (Scope)process);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("childsecond_1", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("childsecond_2", (Behaviour)new EmptyBehaviourImpl()));
        Node node2 = CreationPatternFactory.getInstance().createForkPattern("secondfork", arrayList2, (Scope)process);
        ArrayList<Node> arrayList3 = new ArrayList<Node>();
        arrayList3.add(node);
        arrayList3.add(node2);
        Node node3 = process.createNode("start", (Behaviour)new EmptyBehaviourImpl());
        Node node4 = CreationPatternFactory.getInstance().createForkPattern("fork", arrayList3, (Scope)process);
        Node node5 = process.createNode("end", (Behaviour)new EmptyBehaviourImpl());
        process.linkedBrotherNodes(node3, node4);
        process.linkedBrotherNodes(node4, node5);
        process.setInitialNode(node3);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        Assert.assertEquals((Object)Execution.State.INACTIVE, (Object)execution.getState());
        execution.runStepByStep();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertTrue((boolean)(execution.getCurrentTarget() instanceof Node));
        Node node6 = execution.getCurrentTarget();
        Assert.assertEquals((String)"node_supporting_start", (String)node6.getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertTrue((boolean)(execution.getCurrentTarget() instanceof Node));
        node6 = execution.getCurrentTarget();
        Assert.assertEquals((String)"node_supporting_start", (String)node6.getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertTrue((boolean)(execution.getCurrentTarget() instanceof Node));
        node6 = execution.getCurrentTarget();
        Assert.assertEquals((String)"node_supporting_fork", (String)node6.getName());
        node6 = (Execution)execution.getChildExecutions().get(0);
        Execution execution2 = (Execution)execution.getChildExecutions().get(1);
        node6.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)node6.getState());
        Assert.assertEquals((int)0, (int)node6.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_firstfork", (String)node6.getCurrentTarget().getName());
        execution2.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution2.getState());
        Assert.assertEquals((int)0, (int)execution2.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_secondfork", (String)execution2.getCurrentTarget().getName());
        node6.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)node6.getState());
        Assert.assertEquals((int)2, (int)node6.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_firstfork", (String)node6.getCurrentTarget().getName());
        Execution execution3 = (Execution)node6.getChildExecutions().get(0);
        Execution execution4 = (Execution)node6.getChildExecutions().get(1);
        execution2.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution2.getState());
        Assert.assertEquals((int)2, (int)execution2.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_secondfork", (String)execution2.getCurrentTarget().getName());
        Execution execution5 = (Execution)execution2.getChildExecutions().get(0);
        Execution execution6 = (Execution)execution2.getChildExecutions().get(1);
        execution3.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution3.getState());
        Assert.assertEquals((String)"node_supporting_childfirst_1", (String)execution3.getCurrentTarget().getName());
        node6.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)node6.getState());
        Assert.assertEquals((int)1, (int)node6.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_firstfork", (String)node6.getCurrentTarget().getName());
        execution4.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution4.getState());
        Assert.assertEquals((String)"node_supporting_childfirst_2", (String)execution4.getCurrentTarget().getName());
        node6.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)node6.getState());
        Assert.assertEquals((int)0, (int)node6.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_firstfork", (String)node6.getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        execution5.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution5.getState());
        Assert.assertEquals((String)"node_supporting_childsecond_1", (String)execution5.getCurrentTarget().getName());
        execution2.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution2.getState());
        Assert.assertEquals((int)1, (int)execution2.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_secondfork", (String)execution2.getCurrentTarget().getName());
        execution6.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution6.getState());
        Assert.assertEquals((String)"node_supporting_childsecond_2", (String)execution6.getCurrentTarget().getName());
        execution2.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution2.getState());
        Assert.assertEquals((int)0, (int)execution2.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_secondfork", (String)execution2.getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
    }

    @Test
    public void testForkWithUnderForkAndWithTwoChildAndAroundNodePatternRun() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("childfirst_1", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("childfirst_2", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createForkPattern("firstfork", arrayList, (Scope)process);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("childsecond_1", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("childsecond_2", (Behaviour)new EmptyBehaviourImpl()));
        Node node2 = CreationPatternFactory.getInstance().createForkPattern("secondfork", arrayList2, (Scope)process);
        ArrayList<Node> arrayList3 = new ArrayList<Node>();
        arrayList3.add(node);
        arrayList3.add(node2);
        Node node3 = process.createNode("start", (Behaviour)new EmptyBehaviourImpl());
        Node node4 = CreationPatternFactory.getInstance().createForkPattern("fork", arrayList3, (Scope)process);
        Node node5 = process.createNode("end", (Behaviour)new EmptyBehaviourImpl());
        process.linkedBrotherNodes(node3, node4);
        process.linkedBrotherNodes(node4, node5);
        process.setInitialNode(node3);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        Assert.assertEquals((Object)Execution.State.INACTIVE, (Object)execution.getState());
        execution.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }
}

