/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.expression.AbstractExpressionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class IfPatternTest {
    @Test
    public void testIfValidIfPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        BooleanExpression booleanExpression = new BooleanExpression();
        booleanExpression.setContent("true");
        ArrayList<BooleanExpression> arrayList = new ArrayList<BooleanExpression>();
        arrayList.add(booleanExpression);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createIfPattern("if", arrayList, arrayList2, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testIfInValidPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        BooleanExpression booleanExpression = new BooleanExpression();
        booleanExpression.setContent("false");
        ArrayList<BooleanExpression> arrayList = new ArrayList<BooleanExpression>();
        arrayList.add(booleanExpression);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createIfPattern("if", arrayList, arrayList2, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testIfElseValidIfPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        BooleanExpression booleanExpression = new BooleanExpression();
        booleanExpression.setContent("true");
        ArrayList<BooleanExpression> arrayList = new ArrayList<BooleanExpression>();
        arrayList.add(booleanExpression);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("else", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createIfPattern("if", arrayList, arrayList2, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testIfElseValidElsePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        BooleanExpression booleanExpression = new BooleanExpression();
        booleanExpression.setContent("false");
        ArrayList<BooleanExpression> arrayList = new ArrayList<BooleanExpression>();
        arrayList.add(booleanExpression);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("else", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createIfPattern("if", arrayList, arrayList2, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_else", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testIfElseIfValidFirstPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        BooleanExpression booleanExpression = new BooleanExpression();
        booleanExpression.setContent("true");
        BooleanExpression booleanExpression2 = new BooleanExpression();
        booleanExpression2.setContent("false");
        BooleanExpression booleanExpression3 = new BooleanExpression();
        booleanExpression3.setContent("false");
        ArrayList<BooleanExpression> arrayList = new ArrayList<BooleanExpression>();
        arrayList.add(booleanExpression);
        arrayList.add(booleanExpression2);
        arrayList.add(booleanExpression3);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("third", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createIfPattern("if", arrayList, arrayList2, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testIfElseIfValidSecondPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        BooleanExpression booleanExpression = new BooleanExpression();
        booleanExpression.setContent("false");
        BooleanExpression booleanExpression2 = new BooleanExpression();
        booleanExpression2.setContent("true");
        BooleanExpression booleanExpression3 = new BooleanExpression();
        booleanExpression3.setContent("false");
        ArrayList<BooleanExpression> arrayList = new ArrayList<BooleanExpression>();
        arrayList.add(booleanExpression);
        arrayList.add(booleanExpression2);
        arrayList.add(booleanExpression3);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("third", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createIfPattern("if", arrayList, arrayList2, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testIfElseIfValidThirdPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ifProcess"), null);
        BooleanExpression booleanExpression = new BooleanExpression();
        booleanExpression.setContent("false");
        BooleanExpression booleanExpression2 = new BooleanExpression();
        booleanExpression2.setContent("false");
        BooleanExpression booleanExpression3 = new BooleanExpression();
        booleanExpression3.setContent("true");
        ArrayList<BooleanExpression> arrayList = new ArrayList<BooleanExpression>();
        arrayList.add(booleanExpression);
        arrayList.add(booleanExpression2);
        arrayList.add(booleanExpression3);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        arrayList2.add(process.createNode("third", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createIfPattern("if", arrayList, arrayList2, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        System.out.println("***************************** third = " + process.getParentExecution().getCurrentTarget().getName());
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_if", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    public class BooleanExpression
    extends AbstractExpressionImpl<String, Boolean>
    implements ConditionalExpression<String> {
        private Boolean content;

        public Boolean evaluate(Scope scope) throws CoreException {
            if (this.getContent().equals("true")) {
                return true;
            }
            return false;
        }

        public void setLog(Logger logger) {
        }

        public String getContent() {
            return this.content.toString();
        }

        public void setContent(String string) {
            this.content = Boolean.valueOf(string);
        }

        public Expression<String, Boolean> copypaste() {
            return null;
        }
    }
}

