/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.expression.AbstractExpressionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class LoopPatternTest {
    @Test
    public void testWhilePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition counterCondition = new CounterCondition(3);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("third", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)counterCondition, true, arrayList, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testWhileWithoutUnderActivityPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition counterCondition = new CounterCondition(3);
        List list = null;
        Node node = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)counterCondition, true, list, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testWhileWithOneUnderActivityPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition counterCondition = new CounterCondition(3);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)counterCondition, true, arrayList, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testWhileWithNodeAroundPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition counterCondition = new CounterCondition(3);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("third", (Behaviour)new EmptyBehaviourImpl()));
        Node node = process.createNode("start", (Behaviour)new EmptyBehaviourImpl());
        Node node2 = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)counterCondition, true, arrayList, (Scope)process);
        Node node3 = process.createNode("end", (Behaviour)new EmptyBehaviourImpl());
        process.linkedBrotherNodes(node, node2);
        process.linkedBrotherNodes(node2, node3);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_start", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testWhileWithSequenceInsideAndWithNodeAroundPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition counterCondition = new CounterCondition(3);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("first", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("second", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("third", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createSequencePattern("sequence", arrayList, (Scope)process);
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList2.add(node);
        Node node2 = process.createNode("start", (Behaviour)new EmptyBehaviourImpl());
        Node node3 = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)counterCondition, true, arrayList2, (Scope)process);
        Node node4 = process.createNode("end", (Behaviour)new EmptyBehaviourImpl());
        process.linkedBrotherNodes(node2, node3);
        process.linkedBrotherNodes(node3, node4);
        process.setInitialNode(node2);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component component = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(component);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_start", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    public class CounterCondition
    extends AbstractExpressionImpl<String, Boolean>
    implements ConditionalExpression<String> {
        public int counter = 0;
        public int max = 0;

        public CounterCondition(int n) {
            this.max = n;
        }

        public Boolean evaluate(Scope scope) throws CoreException {
            boolean bl = true;
            if (this.counter == this.max) {
                bl = false;
            }
            ++this.counter;
            return bl;
        }

        public void setLog(Logger logger) {
        }

        public String getContent() {
            return null;
        }

        public void setContent(String string) {
        }

        public Expression<String, Boolean> copypaste() {
            return null;
        }
    }
}

