/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.fault.FaultImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ScopePatternTest {
    @Test
    public void testScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node node = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        Scope scope = (Scope)node.getComponent().getFcInterface("service");
        Node node2 = scope.createNode("start", (Behaviour)new EmptyBehaviourImpl());
        scope.setInitialNode(node2);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"scope", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testEmptyScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node node = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"scope", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testScopeInSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node node = CreationPatternFactory.getInstance().createScopePattern("scopeInSequence_c", (Scope)process);
        Scope scope = (Scope)node.getComponent().getFcInterface("service");
        Node node2 = scope.createNode("startInScope", (Behaviour)new EmptyBehaviourImpl());
        scope.setInitialNode(node2);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("a", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("b", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(node);
        arrayList.add(process.createNode("d", (Behaviour)new EmptyBehaviourImpl()));
        Node node3 = CreationPatternFactory.getInstance().createSequencePattern("seq", arrayList, (Scope)process);
        process.setInitialNode(node3);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_seq", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testScopeInScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node node = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        Scope scope = (Scope)node.getComponent().getFcInterface("service");
        Node node2 = CreationPatternFactory.getInstance().createScopePattern("scopeInScope", scope);
        scope.setInitialNode(node2);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"scope", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testScopeWithFaultPattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeWithFaultProcess"), null);
        Node node = CreationPatternFactory.getInstance().createScopePattern("scopeWithFault", (Scope)process);
        Scope scope = (Scope)node.getComponent().getFcInterface("service");
        Node node2 = CreationPatternFactory.getInstance().createScopePattern("exceptionScope", scope);
        Scope scope2 = (Scope)node2.getComponent().getFcInterface("service");
        ThrowBehaviourImpl throwBehaviourImpl = new ThrowBehaviourImpl();
        throwBehaviourImpl.setException((Exception)((Object)new MyOtherBusinessException("Error in my other business fault")));
        Node node3 = scope2.createNode("startInCatch", (Behaviour)throwBehaviourImpl);
        scope2.setInitialNode(node3);
        HashMap<FaultImpl, Scope> hashMap = new HashMap<FaultImpl, Scope>();
        FaultImpl faultImpl = new FaultImpl();
        faultImpl.setFaultName(new QName(MyBusinessException.class.getName()));
        faultImpl.setFaultHandler((FaultHandler)new FaultMatcherImpl());
        hashMap.put(faultImpl, scope2);
        scope.setExceptions(hashMap);
        ThrowBehaviourImpl throwBehaviourImpl2 = new ThrowBehaviourImpl();
        throwBehaviourImpl2.setException((Exception)((Object)new MyBusinessException("Error in my business fault")));
        Node node4 = scope.createNode("start", (Behaviour)throwBehaviourImpl2);
        scope.setInitialNode(node4);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        try {
            process.run();
            Assert.fail();
        }
        catch (MyOtherBusinessException myOtherBusinessException) {
            Assert.assertEquals((String)"Error in my other business fault", (String)myOtherBusinessException.getMessage());
        }
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"scopeWithFault", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testProcessWithFaultPattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeWithFaultProcess"), null);
        Node node = CreationPatternFactory.getInstance().createScopePattern("exceptionScope", (Scope)process);
        Scope scope = (Scope)node.getComponent().getFcInterface("service");
        ThrowBehaviourImpl throwBehaviourImpl = new ThrowBehaviourImpl();
        throwBehaviourImpl.setException((Exception)((Object)new MyOtherBusinessException("Error in my other business fault")));
        Node node2 = scope.createNode("startInCatch", (Behaviour)throwBehaviourImpl);
        scope.setInitialNode(node2);
        HashMap<FaultImpl, Scope> hashMap = new HashMap<FaultImpl, Scope>();
        FaultImpl faultImpl = new FaultImpl();
        faultImpl.setFaultName(new QName(MyBusinessException.class.getName()));
        faultImpl.setFaultHandler((FaultHandler)new FaultMatcherImpl());
        hashMap.put(faultImpl, scope);
        process.setExceptions(hashMap);
        ThrowBehaviourImpl throwBehaviourImpl2 = new ThrowBehaviourImpl();
        throwBehaviourImpl2.setException((Exception)((Object)new MyBusinessException("Error in my business fault")));
        Node node3 = process.createNode("start", (Behaviour)throwBehaviourImpl2);
        process.setInitialNode(node3);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        try {
            process.run();
            Assert.fail();
        }
        catch (MyOtherBusinessException myOtherBusinessException) {
            Assert.assertEquals((String)"Error in my other business fault", (String)myOtherBusinessException.getMessage());
        }
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
    }

    public class MyOtherBusinessException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public MyOtherBusinessException(String string) {
            super(string);
        }
    }

    public class MyBusinessException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public MyBusinessException(String string) {
            super(string);
        }

        public MyBusinessException() {
        }
    }

    public class FaultMatcherImpl
    implements FaultHandler {
        public boolean match(Scope scope, Fault fault, Exception exception, Scope scope2) {
            return fault.getFaultName().getLocalPart().equals(exception.getClass().getName());
        }

        public void setLog(Logger logger) {
        }

        public <Ex extends CoreException> Ex getModelExceptionFromGenericException(Scope scope, Exception exception) throws CoreException {
            return null;
        }
    }
}

