/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class SequencePatternTest {
    @Test
    public void testSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("start", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("a", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("b", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("c", (Behaviour)new EmptyBehaviourImpl()));
        Node node = CreationPatternFactory.getInstance().createSequencePattern("seq", arrayList, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_seq", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testEmptySequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        ArrayList arrayList = new ArrayList();
        Node node = CreationPatternFactory.getInstance().createSequencePattern("seq", arrayList, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_seq", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testNullSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        Node node = CreationPatternFactory.getInstance().createSequencePattern("seq", null, (Scope)process);
        process.setInitialNode(node);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_seq", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testSequencePatternWithNodeAround() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        Node node = process.createNode("start", (Behaviour)new EmptyBehaviourImpl());
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(process.createNode("a", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("b", (Behaviour)new EmptyBehaviourImpl()));
        arrayList.add(process.createNode("c", (Behaviour)new EmptyBehaviourImpl()));
        Node node2 = process.createNode("end", (Behaviour)new EmptyBehaviourImpl());
        Node node3 = CreationPatternFactory.getInstance().createSequencePattern("seq", arrayList, (Scope)process);
        process.setInitialNode(node);
        process.linkedBrotherNodes(node, node3);
        process.linkedBrotherNodes(node3, node2);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }
}

