/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.service;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SenderBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.ExternalMessageImpl;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.StringVariableImpl;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class AutoFlushServiceTest {
    @Test
    public void testAutoFlushService() throws CoreException, NoSuchInterfaceException, InterruptedException {
        ConfigurationEngineImpl configurationEngineImpl = new ConfigurationEngineImpl();
        configurationEngineImpl.setAutoFlushMessageFreqeuency(Integer.valueOf(1000));
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)configurationEngineImpl, 1, MemoryReceiverImpl.class, 1, SysoutSenderImpl.class, null);
        Engine engine = core.getEngine();
        ExternalMessageImpl externalMessageImpl = new ExternalMessageImpl();
        externalMessageImpl.setContent((Object)"hello world!");
        ((Receiver)core.getExternalEnvironment().getReceivers().get(0)).accept((ExternalMessage)externalMessageImpl, null);
        core.getEngine().getServiceManager().shutdownAllServices();
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Process process = this.createProcess(new QName("Process1"), core);
        process.run();
        while (process.getParentExecution().getState() != Execution.State.SUSPENDED) {
            Thread.sleep(100L);
        }
        core.getEngine().getServiceManager().restartAllServices();
        long l = System.currentTimeMillis();
        while (!process.getParentExecution().getState().equals((Object)Execution.State.ENDED) && System.currentTimeMillis() - l <= 10000L) {
            System.out.println("Wait the auto flush");
            Thread.sleep(500L);
        }
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
    }

    private Process createProcess(QName qName, Core core) throws CoreException {
        StringVariableImpl stringVariableImpl = new StringVariableImpl();
        stringVariableImpl.setQName(new QName("v1"));
        Process process = core.getEngine().createNewEmptyProcessInstance(qName, null);
        process.getVariables().put(stringVariableImpl.getQName(), stringVariableImpl);
        ReceiverBehaviourImpl receiverBehaviourImpl = new ReceiverBehaviourImpl();
        receiverBehaviourImpl.addVariableName(stringVariableImpl.getQName());
        Node node = process.createNode("receive", (Behaviour)receiverBehaviourImpl);
        SenderBehaviourImpl senderBehaviourImpl = new SenderBehaviourImpl();
        senderBehaviourImpl.setKind(SenderBehaviour.Kind.ASYNCHRONOUS);
        senderBehaviourImpl.setInputVariableName(stringVariableImpl.getQName());
        senderBehaviourImpl.setOutputVariableName(stringVariableImpl.getQName());
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        Node node2 = CreationPatternFactory.getInstance().createSequencePattern("seq", arrayList, (Scope)process);
        process.setInitialNode(node2);
        return process;
    }
}

