/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.types.Step;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.Interceptor;
import org.ow2.frascati.tinfi.oasis.ServiceReferenceImpl;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Node.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class NodeImpl
extends SCAComponentImpl
implements Node {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(NodeImpl.class.getName());
    @Reference(name="childNodes", required=false)
    protected List<Node> childNodes = Collections.synchronizedList(new ArrayList());
    @Reference(name="incomingNodes", required=false)
    protected List<Node> incomingNodes = Collections.synchronizedList(new ArrayList());
    @Reference(name="outgoingNodes", required=false)
    protected List<Node> outgoingNodes = Collections.synchronizedList(new ArrayList());
    @Reference(name="behaviour", required=false)
    protected Behaviour behaviour;
    @Reference(name="parentNode", required=false)
    protected Node parentNode;
    @Reference(name="execution", required=false)
    protected Execution execution;

    @Lifecycle(step=Step.STOP)
    public void stopSCAComponent() throws SCAException {
        this.log.finest("node " + this.getName() + " is stopping... ");
        if (this.childNodes != null && this.childNodes.size() > 0) {
            Component parentComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            for (Node child : this.getChildNodes()) {
                this.log.finest("stop child node: " + this.getName());
                Component nodeComp = SCAHelper.getSCAHelper().getComponentByInterface(parentComp, (ServiceReference)child, "service");
                if (nodeComp == null || !SCAHelper.getSCAHelper().isStarted(nodeComp)) continue;
                SCAHelper.getSCAHelper().stopComponent(nodeComp);
            }
        }
        this.log.finest("node stopped: " + this.getName());
    }

    public void setActivity(Behaviour behaviour) {
        this.behaviour = behaviour;
    }

    public Behaviour getActivity() {
        return this.behaviour;
    }

    public void execute() throws CoreException {
        block8: {
            try {
                if (this.behaviour == null) break block8;
                Component activityComp = null;
                activityComp = this.behaviour instanceof ServiceReference ? SCAHelper.getSCAHelper().getComponentByInterface(this.execution.getParentScope().getComponent(), (ServiceReference)this.behaviour, "service") : SCAHelper.getSCAHelper().getComponentByInterface(this.execution.getParentScope().getComponent(), (Interface)this.behaviour, "service");
                if (activityComp != null && !SCAHelper.getSCAHelper().isStarted(activityComp)) {
                    SCAHelper.getSCAHelper().startComponent(activityComp);
                }
                try {
                    this.behaviour.execute();
                }
                catch (CoreException e) {
                    Scope currentScope = this.getExecution().getParentScope();
                    Scope faultScope = this.findFaultScope(currentScope, (Exception)((Object)e));
                    if (faultScope == null || faultScope.isFaultScope() != null) {
                        this.log.finest("fault not catched: " + ((Object)((Object)e)).getClass().getName());
                        this.execution.setState(Execution.State.ENDED);
                        throw e;
                    }
                    this.log.finest("fault catched by scope: " + faultScope.getName());
                    faultScope.setFaultScope((Exception)((Object)e));
                    if (faultScope.getParentScope().getName().equals(this.execution.getParentScope().getName())) {
                        this.getExecution().setNextExecutableElements((SCAComponent)this, (Node)faultScope.getComponent().getFcInterface("service"));
                    }
                    this.execution.setState(Execution.State.ENDED);
                    faultScope.getParentScope().linkedExecution2ExecutableElement(faultScope.getParentScope().getExecution(), (Node)faultScope);
                    faultScope.getParentScope().linkedExecutableElement2Execution((Node)faultScope, faultScope.getParentScope().getExecution());
                    faultScope.execute();
                }
                this.log.finest("State of behaviour's node: " + this.getName() + " => " + this.getBehaviour().getState());
            }
            catch (NoSuchInterfaceException e1) {
                throw new CoreException((Throwable)e1);
            }
            catch (SCAException e1) {
                throw new CoreException((Throwable)e1);
            }
        }
    }

    private Scope findFaultScope(Scope currentScope, Exception e) throws CoreException {
        Scope faultScope = null;
        Exception exTest = null;
        Scope current = currentScope;
        while (exTest == null && current != null) {
            exTest = current.isFaultScope();
            current = current.getParentScope();
        }
        if (exTest == null) {
            for (Map.Entry entry : currentScope.getExceptions().entrySet()) {
                if (((Fault)entry.getKey()).getFaultHandler() == null || !((Fault)entry.getKey()).getFaultHandler().match(currentScope, (Fault)entry.getKey(), e, (Scope)entry.getValue())) continue;
                faultScope = (Scope)entry.getValue();
                break;
            }
            if (faultScope == null && currentScope.getParentScope() != null) {
                faultScope = this.findFaultScope(currentScope.getParentScope(), e);
            }
        }
        return faultScope;
    }

    public void selectDefaultNextTarget() throws CoreException {
        this.log.finest("select default next target");
        Execution execution = this.getExecution();
        boolean b = execution.hasNextExecutableElement();
        if (!b) {
            List<Node> out = this.getOutgoingNodes();
            this.log.finest("list of following transition: " + out);
            this.log.finest("this.getParentNode(): " + this.getParentNode());
            this.log.finest("this.getExecution(): " + this.getExecution());
            if (out.size() == 1) {
                this.getExecution().setNextExecutableElements((SCAComponent)this, out);
            } else if (this.getParentNode() != null) {
                this.log.finest("this.getParentNode().getExecution(): " + this.getParentNode().getExecution());
                if (this.getExecution().getParentExecution() != null) {
                    if (this.getParentNode().getExecution() == this.getExecution()) {
                        this.log.finest("parent node is next target: " + this.getParentNode().getName());
                        this.getExecution().setNextExecutableElements((SCAComponent)this, this.getParentNode());
                    } else {
                        this.getExecution().setNextExecutableElements((SCAComponent)this, (Collection)Collections.EMPTY_LIST);
                    }
                } else {
                    this.log.finest("parent node is next target: " + this.getParentNode().getName());
                    this.getExecution().setNextExecutableElements((SCAComponent)this, this.getParentNode());
                }
            } else {
                this.getExecution().setNextExecutableElements((SCAComponent)this, (Collection)Collections.EMPTY_LIST);
            }
        }
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public List<Node> getChildNodes() {
        return new ArrayList<Node>(this.childNodes);
    }

    public Behaviour getBehaviour() {
        if (this.behaviour instanceof Interface) {
            return this.behaviour;
        }
        if (this.behaviour != null) {
            ServiceReference sr = (ServiceReference)this.behaviour;
            ServiceReferenceImpl cri = (ServiceReferenceImpl)sr;
            Object service = cri._getDelegate();
            ComponentInterface ci = (ComponentInterface)service;
            Interceptor intercep = (Interceptor)ci.getFcItfImpl();
            Behaviour itf = (Behaviour)intercep.getFcItfDelegate();
            return itf;
        }
        return null;
    }

    public String toString() {
        String res = "";
        res = "node " + this.getName();
        return res;
    }

    public List<Node> getIncomingNodes() {
        return this.incomingNodes;
    }

    public List<Node> getOutgoingNodes() {
        return this.outgoingNodes;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setExecution(Execution exec) {
        this.execution = exec;
    }
}

