/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={IfBehaviour.class}, names={"service"})
public class IfBehaviourImpl
extends AbstractBehaviourImpl
implements IfBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(IfBehaviourImpl.class.getName());
    private List<ConditionalExpression> conditions;

    public Map<String, Object> getInitializationContext() throws SCAException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("conditions", this.conditions);
        return context;
    }

    public void setInitializationContext(Map<String, Object> context) throws SCAException {
        this.conditions = (List)context.get("conditions");
    }

    public String toString() {
        return "If behaviour";
    }

    public List<ConditionalExpression> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ConditionalExpression> expression) {
        this.conditions = expression;
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    protected void executeOnEnded() throws CoreException {
    }

    protected void executeOnInactive() throws CoreException {
        this.log.finest("start if behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        if (this.conditions != null && this.conditions.size() > 0) {
            Iterator<ConditionalExpression> itExpressions = this.conditions.iterator();
            Iterator itNodes = this.node.getChildNodes().iterator();
            ConditionalExpression expression = null;
            Node selectedChild = null;
            boolean find = false;
            while (itExpressions.hasNext() && !find) {
                expression = itExpressions.next();
                System.err.println("## expression to evaluate : " + expression.getContent());
                selectedChild = (Node)itNodes.next();
                Boolean cond = (Boolean)expression.evaluate(this.getNode().getExecution().getParentScope());
                if (cond == null || !cond.booleanValue()) continue;
                this.getNode().getExecution().setNextExecutableElements((SCAComponent)this, selectedChild);
                find = true;
            }
            if (!find && itNodes.hasNext()) {
                selectedChild = (Node)itNodes.next();
                this.getNode().getExecution().setNextExecutableElements((SCAComponent)this, selectedChild);
                find = true;
            }
            if (!find) {
                this.log.finest("end if behaviour on node: " + this.node.getName());
                this.state = Behaviour.State.ACTIVITY_ENDED;
            }
        } else {
            throw new CoreException("Invalid if pattern");
        }
    }

    protected void executeOnStarted() throws CoreException {
        this.log.finest("end if behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_ENDED;
    }
}

