/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.ExtendedBehaviour;

public interface LoggerBehaviour extends ExtendedBehaviour, EchoBehaviour {

	enum LEVEL{SEVERE, WARNING, INFO, DEBUG};
	
	QName name = new QName(ExtendedBehaviour.name.getNamespaceURI(), "Logger");

	LEVEL getLevel();

	void setLevel(LEVEL level);

	void severe(String msg);
	
	void warning(String msg);
	
	void info(String msg);
	
	void debug(String msg);
}
