/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.factory.AbstractFactoryImpl;
import com.ebmwebsourcing.easyviper.core.api.factory.Factory;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageConverter;
import com.ebmwebsourcing.easyviper.core.impl.CoreImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.ExternalMessageImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.IdenticalMessageConverterImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.InternalMessageImpl;
import java.util.logging.Logger;

public class GenericFactory
extends AbstractFactoryImpl
implements Factory {
    private static GenericFactory instance;

    private GenericFactory() {
    }

    public static GenericFactory getInstance() {
        if (instance == null) {
            instance = new GenericFactory();
        }
        return instance;
    }

    public Core createCore(ConfigurationEngine configuration, int numberOfReceivers, Class<? extends Receiver> receiverClass, int numberOfSenders, Class<? extends Sender> senderClass, Logger logger) throws CoreException {
        InternalMessageImpl internalMessage = new InternalMessageImpl();
        ExternalMessageImpl externalMessage = new ExternalMessageImpl();
        IdenticalMessageConverterImpl converter = new IdenticalMessageConverterImpl(externalMessage.getClass(), internalMessage.getClass());
        return this.createCore(configuration, (MessageConverter)converter, numberOfReceivers, receiverClass, numberOfSenders, senderClass, logger);
    }

    public Core createCore(ConfigurationEngine configuration, MessageConverter converter, int numberOfReceivers, Class<? extends Receiver> receiverClass, int numberOfSenders, Class<? extends Sender> senderClass, Logger logger) throws CoreException {
        int i;
        Core core = super.createCore("core", configuration, CoreImpl.class);
        if (logger != null) {
            core.setLog(logger);
        }
        Engine engine = core.createEngine(configuration, converter.getInternalMessageType());
        ExternalEnvironment externalEnvironment = core.createExternalEnvironment("ExternalEnvironment");
        for (i = 0; i < numberOfReceivers; ++i) {
            externalEnvironment.addReceiver(receiverClass, converter);
        }
        for (i = 0; i < numberOfSenders; ++i) {
            externalEnvironment.addSender(senderClass, converter);
        }
        return core;
    }
}

