/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api;

import java.util.HashMap;
import java.util.Map;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=ExtendedBehaviour.class,names="extended_behavior_service")
@PolicySets("frascati:scaEasyPrimitive")
public abstract class AbstractExtendedBehaviourImpl extends AbstractBehaviourImpl implements ExtendedBehaviour {



	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private ClassLoader classloader;

	protected Map<String, Object> context = new HashMap<String, Object>();

	public AbstractExtendedBehaviourImpl() {
		
	}

	public ClassLoader getClassLoader() {
		return this.classloader;
	}


	public void setClassLoader(ClassLoader classloader) {
		this.classloader = classloader;
	}


	public Map<String, Object> getInitializationContext() throws SCAException {
		if(this.classloader != null) {
			context.put("classloader", this.classloader);
		}
		return context;
	}

}
